/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.simple;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.core.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoginModule
extends AbstractLoginModule {
    private static Logger log = LoggerFactory.getLogger(SimpleLoginModule.class);

    @Override
    protected void doInit(CallbackHandler callbackHandler, Session session, Map options) throws LoginException {
        log.debug("init: SimpleLoginModule. Done.");
    }

    @Override
    protected boolean impersonate(Principal principal, Credentials credentials) throws RepositoryException, LoginException {
        if (principal instanceof Group) {
            return false;
        }
        Subject impersSubject = this.getImpersonatorSubject(credentials);
        return impersSubject != null;
    }

    @Override
    protected Authentication getAuthentication(Principal principal, Credentials creds) throws RepositoryException {
        if (principal instanceof Group) {
            return null;
        }
        return new Authentication(){

            @Override
            public boolean canHandle(Credentials credentials) {
                return true;
            }

            @Override
            public boolean authenticate(Credentials credentials) throws RepositoryException {
                return true;
            }
        };
    }

    @Override
    protected Principal getPrincipal(Credentials credentials) {
        String userId = this.getUserID(credentials);
        Principal principal = this.principalProvider.getPrincipal(userId);
        if (principal == null || principal instanceof Group) {
            return null;
        }
        return principal;
    }
}

