/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellDeploymentStep;
import com.xebialabs.deployit.plugin.powershell.PowerShellStepUtils;
import com.xebialabs.deployit.plugin.powershell.PowerShellVarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellBatchDeploymentStep
implements Step,
PreviewStep {
    private int order;
    private HostContainer container;
    private List<PowerShellDeploymentStep> steps;
    private String description;
    private Preview preview;
    private Logger logger = LoggerFactory.getLogger(PowerShellBatchDeploymentStep.class);

    public PowerShellBatchDeploymentStep(int order, HostContainer container, List<PowerShellDeploymentStep> steps, String description) {
        this.order = order;
        this.container = container;
        this.steps = Lists.newArrayList(steps);
        this.description = description;
    }

    public Preview getPreview() {
        if (this.preview == null) {
            return PowerShellStepUtils.previewPowerShellScript(this.getPowerShellScriptCallback());
        }
        return this.preview;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return PowerShellStepUtils.executePowerShellScript(this.container, ctx, this.getPowerShellScriptCallback());
    }

    private PowerShellStepUtils.PowerShellScriptCallback getPowerShellScriptCallback() {
        return new PowerShellStepUtils.PowerShellScriptCallback(){

            @Override
            public String getScriptPath() {
                return "combined.ps1";
            }

            @Override
            public String generateScript(OverthereConnection conn) {
                return PowerShellBatchDeploymentStep.this.doGenerateScript(conn);
            }

            @Override
            public void uploadAdditionalResources(HostContainer container, ExecutionContext ctx, OverthereConnection conn) {
            }
        };
    }

    public String doGenerateScript(OverthereConnection conn) {
        this.logger.debug("Generating PowerShell batch script for step [{}]", (Object)this.getDescription());
        StringBuilder combinedScriptBuffer = new StringBuilder();
        for (PowerShellDeploymentStep s : this.steps) {
            this.logger.debug("Appending contents of step [{}]", (Object)s.getDescription());
            combinedScriptBuffer.append("Write-Host '===', " + PowerShellVarsConverter.toPowerShellString(s.getDescription()) + ", '==='\r\n");
            combinedScriptBuffer.append("& {\r\n");
            combinedScriptBuffer.append(s.doGenerateScript(conn));
            combinedScriptBuffer.append("}\r\n");
        }
        return combinedScriptBuffer.toString();
    }

    public int getOrder() {
        return this.order;
    }

    public String getDescription() {
        return this.description;
    }
}

