/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.Map;

public abstract class AbstractStepConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        StepState s = (StepState)source;
        writer.addAttribute("failures", Integer.toString(s.getFailureCount()));
        writer.addAttribute("state", s.getState().name());
        Converters.writeNode("description", s.getDescription(), writer);
        if (s.getStartDate() != null) {
            Converters.writeNode("startDate", new DateTimeAdapter().marshal(s.getStartDate()), writer);
        }
        if (s.getCompletionDate() != null) {
            Converters.writeNode("completionDate", new DateTimeAdapter().marshal(s.getCompletionDate()), writer);
        }
        if (s.getLog() != null) {
            Converters.writeNode("log", s.getLog(), writer);
        }
        Map metadata = s.getMetadata();
        writer.startNode("metadata");
        for (Map.Entry e : metadata.entrySet()) {
            Converters.writeNode((String)e.getKey(), (String)e.getValue(), writer);
        }
        writer.endNode();
    }

    public boolean canConvert(Class type) {
        return StepState.class.isAssignableFrom(type);
    }
}

