/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.collect.Lists;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CifsFile
extends BaseOverthereFile<CifsConnection> {
    private SmbFile smbFile;
    private static Logger logger = LoggerFactory.getLogger(CifsFile.class);

    protected CifsFile(CifsConnection connection, SmbFile smbFile) {
        super(connection);
        this.smbFile = smbFile;
    }

    protected SmbFile getSmbFile() {
        return this.smbFile;
    }

    @Override
    public String getPath() {
        return ((CifsConnection)this.connection).encoder.fromUncPath(this.smbFile.getUncPath());
    }

    @Override
    public String getName() {
        return this.smbFile.getName();
    }

    @Override
    public OverthereFile getParentFile() {
        try {
            return new CifsFile((CifsConnection)this.getConnection(), new SmbFile(this.smbFile.getParent(), ((CifsConnection)this.connection).authentication));
        }
        catch (MalformedURLException exc) {
            return null;
        }
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        logger.debug("Checking {} for existence", (Object)this);
        try {
            return this.smbFile.exists();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine existence of %s: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        logger.debug("Checking whether {} can be read", (Object)this);
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine whether %s can be read: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        logger.debug("Checking whether {} can be written", (Object)this);
        try {
            return this.smbFile.canWrite();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine whether %s can be written: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        logger.debug("Checking whether {} can be executed", (Object)this);
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine whether %s can be executed: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public boolean isFile() throws RuntimeIOException {
        logger.debug("Checking whether {} is a file", (Object)this);
        try {
            return this.smbFile.isFile();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine whether %s is a file: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        logger.debug("Checking whether {} is a directory", (Object)this);
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine whether %s is a directory: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public boolean isHidden() {
        logger.debug("Checking whether {} is hidden", (Object)this);
        try {
            return this.smbFile.isHidden();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine whether %s is hidden: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public long lastModified() {
        logger.debug("Retrieving last modification date of {}", (Object)this);
        try {
            return this.smbFile.lastModified();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine last modification timestamp of %s: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public long length() throws RuntimeIOException {
        logger.debug("Retrieving length of {}", (Object)this);
        try {
            return this.smbFile.length();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot determine length of file %s", this, exc.toString()), exc);
        }
    }

    @Override
    public List<OverthereFile> listFiles() throws RuntimeIOException {
        logger.debug("Listing directory {}", (Object)this);
        try {
            this.upgradeToDirectorySmbFile();
            ArrayList files = Lists.newArrayList();
            for (String name : this.smbFile.list()) {
                files.add(this.getFile(name));
            }
            return files;
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException(String.format("Cannot list directory %s: %s", this, exc.toString()), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot list directory %s: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        logger.debug("Creating directory {}", (Object)this);
        try {
            this.smbFile.mkdir();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot create directory %s: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        logger.debug("Creating directories {}", (Object)this);
        try {
            this.smbFile.mkdirs();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot create directories %s: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public void renameTo(OverthereFile dest) throws RuntimeIOException {
        logger.debug("Renaming {} to {}", (Object)this, (Object)dest);
        if (dest instanceof CifsFile) {
            SmbFile targetSmbFile = ((CifsFile)dest).getSmbFile();
            try {
                this.smbFile.renameTo(targetSmbFile);
            }
            catch (SmbException exc) {
                throw new RuntimeIOException(String.format("Cannot move/rename %s to %s: %s", this, dest, exc.toString()), exc);
            }
        } else {
            throw new RuntimeIOException(String.format("Cannot move/rename cifs:%s: file/directory %s  to non-cifs:%s: file/directory %s", ((CifsConnection)this.connection).cifsConnectionType.toString().toLowerCase(), this, ((CifsConnection)this.connection).cifsConnectionType.toString().toLowerCase(), dest));
        }
    }

    @Override
    public void setExecutable(boolean executable) {
    }

    @Override
    public void delete() throws RuntimeIOException {
        logger.debug("Deleting {}", (Object)this);
        try {
            if (this.smbFile.isDirectory()) {
                this.upgradeToDirectorySmbFile();
                if (this.smbFile.list().length > 0) {
                    throw new RuntimeIOException(String.format("Cannot delete non-empty directory %s", this));
                }
            }
            this.smbFile.delete();
            this.refreshSmbFile();
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException(String.format("Cannot delete %s: %s", this, exc.toString()), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot delete %s: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        logger.debug("Deleting {} recursively", (Object)this);
        try {
            if (this.smbFile.isDirectory()) {
                this.upgradeToDirectorySmbFile();
            }
            this.smbFile.delete();
            this.refreshSmbFile();
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException(String.format("Cannot delete %s recursively: %s", this, exc.toString()), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException(String.format("Cannot delete %s recursively: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        logger.debug("Opening CIFS input stream for {}", (Object)this);
        try {
            final InputStream wrapped = this.smbFile.getInputStream();
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return wrapped.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return wrapped.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return wrapped.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return wrapped.skip(n);
                }

                @Override
                public int available() throws IOException {
                    return wrapped.available();
                }

                @Override
                public boolean markSupported() {
                    return wrapped.markSupported();
                }

                @Override
                public void mark(int readlimit) {
                    wrapped.mark(readlimit);
                }

                @Override
                public void reset() throws IOException {
                    wrapped.reset();
                }

                @Override
                public void close() throws IOException {
                    logger.debug("Closing CIFS input stream for {}", (Object)CifsFile.this);
                    wrapped.close();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException(String.format("Cannot open %s for reading: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening CIFS output stream for {}", (Object)this);
        try {
            final OutputStream wrapped = this.smbFile.getOutputStream();
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    wrapped.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    wrapped.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    wrapped.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    wrapped.flush();
                }

                @Override
                public void close() throws IOException {
                    logger.debug("Closing CIFS output stream for {}", (Object)CifsFile.this);
                    wrapped.close();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException(String.format("Cannot open %s for writing: %s", this, exc.toString()), exc);
        }
    }

    private void upgradeToDirectorySmbFile() throws MalformedURLException {
        if (!this.smbFile.getPath().endsWith("/")) {
            this.smbFile = new SmbFile(this.smbFile.getURL() + "/", ((CifsConnection)this.connection).authentication);
        }
    }

    private void refreshSmbFile() throws MalformedURLException {
        this.smbFile = new SmbFile(this.smbFile.getPath(), ((CifsConnection)this.connection).authentication);
    }

    public boolean equals(Object that) {
        if (!(that instanceof CifsFile)) {
            return false;
        }
        return this.getPath().equals(((CifsFile)that).getPath());
    }

    public int hashCode() {
        return this.smbFile.getPath().hashCode();
    }

    @Override
    public String toString() {
        return this.getConnection() + "/" + this.getPath();
    }
}

