/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.CompositePlan;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.deployment.planner.ParallelPlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.Blocks;
import com.xebialabs.deployit.engine.tasker.ImmutableBlock;
import com.xebialabs.deployit.engine.tasker.ParallelBlock;
import com.xebialabs.deployit.engine.tasker.SerialBlock;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.service.deployment.PartialCommitTrigger;
import com.xebialabs.deployit.service.deployment.RepositoryUpdateTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.deployit.task.step.RepositoryUpdateStep;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentService {
    private final Planner planner;
    private RepositoryAdapterFactory repositoryFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(Planner planner, RepositoryAdapterFactory repositoryFactory) {
        this.planner = planner;
        this.repositoryFactory = repositoryFactory;
    }

    public DeltaSpecification prepareInitialDeployment(DeployedApplication deployedApp) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial(deployedApp);
        DeploymentOperationCalculator.calculate(builder, Sets.newHashSet(), deployedApp.getDeployeds());
        return builder.build();
    }

    public DeltaSpecification prepareUpgradeDeployment(DeployedApplication newDeployment, DeployedApplication existingDeployment) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().upgrade(existingDeployment, newDeployment);
        logger.trace("Incoming Deployeds {}", (Object)newDeployment.getDeployeds());
        logger.trace("Existing Deployeds {}", (Object)existingDeployment.getDeployeds());
        DeploymentOperationCalculator.calculate(builder, existingDeployment.getDeployeds(), newDeployment.getDeployeds());
        return builder.build();
    }

    public DeltaSpecification prepareUndeployment(DeployedApplication deployedApplication) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().undeploy(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, deployedApplication.getDeployeds(), Sets.newHashSet());
        return builder.build();
    }

    public TaskSpecification getTaskSpecification(DeltaSpecification deltaSpecification, WorkDir currentWorkDir, WorkDir ... workdirsToCleanup) {
        TaskSpecification spec = null;
        switch (deltaSpecification.getOperation()) {
            case CREATE: {
                spec = this.getTaskSpecification("Initial deployment of " + deltaSpecification.getDeployedApplication().getId(), deltaSpecification, currentWorkDir, workdirsToCleanup);
                DeploymentService.addMetadata(spec, deltaSpecification.getDeployedApplication(), TaskType.INITIAL);
                break;
            }
            case DESTROY: {
                spec = this.getTaskSpecification("Undeployment of " + deltaSpecification.getPreviousDeployedApplication().getId(), deltaSpecification, currentWorkDir, workdirsToCleanup);
                DeploymentService.addMetadata(spec, deltaSpecification.getPreviousDeployedApplication(), TaskType.UNDEPLOY);
                break;
            }
            case MODIFY: {
                String description = "Update deployment of " + deltaSpecification.getPreviousDeployedApplication().getId();
                spec = this.getTaskSpecification(description, deltaSpecification, currentWorkDir, workdirsToCleanup);
                DeploymentService.addMetadata(spec, deltaSpecification.getDeployedApplication(), TaskType.UPGRADE);
                break;
            }
        }
        return spec;
    }

    private TaskSpecification getTaskSpecification(String description, DeltaSpecification specification, WorkDir currentWorkDir, WorkDir ... workDirsToCleanup) {
        DeploymentService.unsetTokensForRealityPush(specification);
        File currentWorkDirPath = new File(currentWorkDir.getPath());
        Plan plan = this.planner.plan(specification, this.repositoryFactory.create(currentWorkDirPath));
        logger.info("Generated plan:\n{}", (Object)plan.writePlan((Writer)new StringWriter()));
        SerialBlock executionBlock = Blocks.serial((String)"1", this.planToBlocks(plan, "1"));
        if (executionBlock.getStepList().isEmpty()) {
            executionBlock = Blocks.steps((String)"1", (List)Lists.newArrayList((Object[])new TaskStep[]{new TaskStep((Step)new RepositoryUpdateStep())}));
        }
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication().getName(), (Block)executionBlock, null, currentWorkDirPath, true, true);
        spec.getListeners().addAll(plan.getListeners());
        ArrayList workDirs = Lists.newArrayList((Object[])workDirsToCleanup);
        workDirs.add(currentWorkDir);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDirs));
        spec.getListeners().add(new RepositoryUpdateTrigger(specification));
        spec.getListeners().add(this.createPartialCommitTrigger(specification, plan));
        return spec;
    }

    protected ExecutionStateListener createPartialCommitTrigger(DeltaSpecification specification, Plan plan) {
        return new PartialCommitTrigger(specification, plan.findCheckpoints());
    }

    List<ImmutableBlock> planToBlocks(Plan plan, String idPrefix) {
        if (plan instanceof StepPlan) {
            return Arrays.asList(Blocks.steps((String)idPrefix, DeploymentService.asTaskSteps((StepPlan)plan)));
        }
        CompositePlan compositePlan = (CompositePlan)plan;
        ArrayList subBlocks = Lists.newArrayList();
        int subPlanFirstId = 1;
        for (Plan p : compositePlan.getSubPlans()) {
            subBlocks.addAll(this.planToBlocks(p, idPrefix + "-" + subPlanFirstId));
            ++subPlanFirstId;
        }
        ParallelBlock b = null;
        if (compositePlan instanceof ParallelPlan) {
            b = Blocks.parallel((String)String.valueOf(idPrefix), (List)subBlocks);
        } else if (compositePlan instanceof SerialPlan) {
            b = Blocks.serial((String)String.valueOf(idPrefix), (List)subBlocks);
        }
        return Arrays.asList(b);
    }

    private static void unsetTokensForRealityPush(DeltaSpecification specification) {
        specification.getDeployedApplication().set$token(null);
        for (Delta delta : specification.getDeltas()) {
            Deployed ci = delta.getDeployed();
            DeploymentService.unsetTokenOnCi((ConfigurationItem)ci);
        }
    }

    private static void unsetTokenOnCi(ConfigurationItem ci) {
        if (ci instanceof BaseConfigurationItem) {
            BaseConfigurationItem bci = (BaseConfigurationItem)ci;
            bci.set$token(null);
            DeploymentService.unsetTokensOnEmbeddeds(bci);
        }
    }

    private static void unsetTokensOnEmbeddeds(BaseConfigurationItem deployed) {
        Collection propertyDescriptors = deployed.getType().getDescriptor().getPropertyDescriptors();
        Collection embeddedProperties = Collections2.filter((Collection)propertyDescriptors, (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return input.isAsContainment() && EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(input.getKind()) && input.getReferencedType().instanceOf(Type.valueOf(EmbeddedDeployed.class));
            }
        });
        for (PropertyDescriptor embeddedProperty : embeddedProperties) {
            Collection c = (Collection)embeddedProperty.get((ConfigurationItem)deployed);
            for (ConfigurationItem configurationItem : c) {
                DeploymentService.unsetTokenOnCi(configurationItem);
            }
        }
    }

    private static void addMetadata(TaskSpecification spec, DeployedApplication deployedApp, TaskType taskType) {
        TaskMetadata.putMetadata(spec, "environment_id", deployedApp.getEnvironment().getId());
        TaskMetadata.putMetadata(spec, "environment", deployedApp.getEnvironment().getName());
        TaskMetadata.putMetadata(spec, "version", deployedApp.getVersion().getName());
        TaskMetadata.putMetadata(spec, "application", deployedApp.getVersion().getApplication().getName());
        TaskMetadata.putMetadata(spec, "taskType", taskType.name());
    }

    private static List<TaskStep> asTaskSteps(StepPlan plan) {
        return Lists.newArrayList((Iterable)Lists.transform((List)plan.getStepsWithDelta(), (Function)new Function<StepPlan.StepWithDelta, TaskStep>(){

            public TaskStep apply(StepPlan.StepWithDelta input) {
                TaskStep taskStep = new TaskStep(input.getStep());
                int i = 0;
                for (Delta delta : input.getDeltas()) {
                    taskStep.getMetadata().put("deployed_" + i++, DeploymentService.getActiveDeployed(delta).getId());
                    taskStep.getMetadata().put("order", Integer.toString(input.getStep().getOrder()));
                    taskStep.getMetadata().put("previewAvailable", Boolean.toString(input.getStep() instanceof PreviewStep));
                }
                return taskStep;
            }
        }));
    }

    private static Deployed getActiveDeployed(Delta delta) {
        return delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
    }
}

