/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TypeCalculator {
    private static final Logger logger = LoggerFactory.getLogger(TypeCalculator.class);

    public Type findMostSpecificDeployedTypeForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        List<Type> deployedTypesForDeployableAndContainer = this.findDeployedTypesForDeployableAndContainerTypes(deployableType, containerType);
        List<Type> copy = this.filterMostSpecific(deployedTypesForDeployableAndContainer);
        if (copy.isEmpty()) {
            return null;
        }
        if (copy.size() == 1) {
            return copy.get(0);
        }
        throw new Checks.IncorrectArgumentException(String.format("Found %s for %s and %s, expected exactly 1. Before filtering we had: %s", copy, deployableType, containerType, deployedTypesForDeployableAndContainer), new Object[0]);
    }

    public List<Type> findAllMostSpecificDeployedTypesForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        return this.filterMostSpecific(this.findDeployedTypesForDeployableAndContainerTypes(deployableType, containerType));
    }

    List<Type> filterMostSpecific(List<Type> deployedTypesForDeployableAndContainer) {
        ArrayList copy = Lists.newArrayList(deployedTypesForDeployableAndContainer);
        for (Type currentType : deployedTypesForDeployableAndContainer) {
            Descriptor currentDescriptor = DescriptorRegistry.getDescriptor((Type)currentType);
            Type currentDeployableType = currentDescriptor.getDeployableType();
            Type currentContainerType = currentDescriptor.getContainerType();
            Iterator copyIt = copy.iterator();
            while (copyIt.hasNext()) {
                Type comparedType = (Type)copyIt.next();
                Descriptor comparedDescriptor = DescriptorRegistry.getDescriptor((Type)comparedType);
                Type comparedDeployableType = comparedDescriptor.getDeployableType();
                Type comparedContainerType = comparedDescriptor.getContainerType();
                boolean deployableEquals = comparedDeployableType.equals((Object)currentDeployableType);
                boolean containerEquals = comparedContainerType.equals((Object)currentContainerType);
                boolean containerSupertype = comparedContainerType.isSuperTypeOf(currentContainerType);
                boolean deployableSupertype = comparedDeployableType.isSuperTypeOf(currentDeployableType);
                boolean isSupertype = comparedType.isSuperTypeOf(currentType);
                String currentTypeString = String.format("%s<%s, %s>", currentType, currentDeployableType, currentContainerType);
                String comparedTypeString = String.format("%s<%s, %s>", comparedType, comparedDeployableType, comparedContainerType);
                if (containerSupertype && deployableEquals) {
                    logger.debug("Filtering out [{}] because is has a container supertype wrt. [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                    copyIt.remove();
                    continue;
                }
                if (deployableSupertype && containerEquals) {
                    logger.debug("Filtering out [{}] because is has a deployable supertype wrt. [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                    copyIt.remove();
                    continue;
                }
                if (deployableSupertype && containerSupertype) {
                    logger.debug("Filtering out [{}] because is has a container and deployable supertype wrt. [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                    copyIt.remove();
                    continue;
                }
                if (!isSupertype) continue;
                logger.debug("Filtering out [{}] because is a supertype of [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                copyIt.remove();
            }
        }
        logger.debug("Result of filtering most specific: {}", (Object)copy);
        return copy;
    }

    public List<Type> findDeployedTypesForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        Collection deployedTypes = DescriptorRegistry.getSubtypes((Type)Type.valueOf(EmbeddedDeployedContainer.class));
        final Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployableType);
        final Descriptor containerDesc = DescriptorRegistry.getDescriptor((Type)containerType);
        ArrayList result = Lists.newArrayList((Iterable)Collections2.filter((Collection)deployedTypes, (Predicate)new Predicate<Type>(){

            public boolean apply(Type input) {
                Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)input);
                return !deployedDesc.isVirtual() && deployableDesc.isAssignableTo(deployedDesc.getDeployableType()) && containerDesc.isAssignableTo(deployedDesc.getContainerType());
            }
        }));
        logger.debug("Found types {} for <{}, {}>", new Object[]{result, deployableType, containerType});
        return result;
    }
}

