/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamSource
implements ImportSource {
    private final String fileName;
    private final InputStream stream;
    private FileSource file;
    private final File tempDir;

    public InputStreamSource(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
        this.tempDir = Files.createTempDir();
    }

    public File getFile() {
        if (this.file == null) {
            this.streamToTempFile();
        }
        return this.file.getFile();
    }

    private void streamToTempFile() {
        try {
            String fileName = this.fileName;
            int slash = fileName.lastIndexOf(47);
            if (slash != -1 && slash != fileName.length() - 1) {
                fileName = fileName.substring(slash);
            }
            File tempFile = new File(this.tempDir, fileName);
            ByteStreams.copy((InputStream)this.stream, (OutputSupplier)Files.newOutputStreamSupplier((File)tempFile));
            this.file = new FileSource(tempFile, true);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void cleanUp() {
        if (this.file != null) {
            this.file.cleanUp();
        }
        GuavaFiles.deleteQuietly((File)this.tempDir);
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.file != null ? this.file : "no file on disk") + "]";
    }
}

