/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.Recovery;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.setup.Setup;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitBootstrapper {
    private static final File DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf");
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);

    public static void main(String[] args) {
        ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
        if (launchOptions == null) {
            return;
        }
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        logger.info("Deployit version {} (built at {})", (Object)releaseInfo.getVersion(), (Object)releaseInfo.getDate());
        logger.info("(c) 2008-{} XebiaLabs", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        ServerConfigFile serverConfigFile = new ServerConfigFile(DEFAULT_CONFIGURATION_FILE);
        if (launchOptions.isDoSetup()) {
            DeployitBootstrapper.startSetup(launchOptions, serverConfigFile);
        } else {
            if (!serverConfigFile.exists()) {
                logger.error("Configuration not found...");
                DeployitBootstrapper.startSetup(launchOptions, serverConfigFile);
            } else if (launchOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            } else if (launchOptions.isRecovery()) {
                logger.warn("Running in recovery mode.");
                new Recovery(launchOptions, serverConfigFile).run();
                return;
            }
            DeployitBootstrapper.startServer(launchOptions, serverConfigFile);
        }
    }

    private static void startServer(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        logger.info("Starting server...");
        try {
            Server.start((String)"Deployit Server", (ServerLaunchOptions)launchOptions, (ServerConfigFile)serverConfigFile);
        }
        catch (Throwable e) {
            logger.error("Fatal error starting server", e);
        }
    }

    private static void startSetup(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        new Setup("Deployit Server", serverConfigFile, launchOptions).run();
    }
}

