/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.db.TempFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWrapper {
    static Logger log = LoggerFactory.getLogger(StreamWrapper.class);
    private InputStream stream;
    private final long size;

    public StreamWrapper(InputStream in, long size) {
        this.stream = in;
        this.size = size;
    }

    public InputStream getStream() {
        if (this.stream instanceof TempFileInputStream) {
            return new BufferedInputStream(this.stream);
        }
        return this.stream;
    }

    public long getSize() {
        return this.size;
    }

    public void cleanupResources() {
        if (this.stream instanceof TempFileInputStream) {
            try {
                this.stream.close();
                ((TempFileInputStream)((Object)this.stream)).deleteFile();
            }
            catch (IOException e) {
                log.warn("Unable to cleanup the TempFileInputStream");
            }
        }
    }

    public boolean resetStream() {
        if (this.stream instanceof TempFileInputStream) {
            try {
                TempFileInputStream tempFileInputStream = (TempFileInputStream)((Object)this.stream);
                tempFileInputStream.close();
                this.stream = new TempFileInputStream(tempFileInputStream.getFile(), true);
                return true;
            }
            catch (Exception e) {
                log.warn("Failed to create a new TempFileInputStream", (Throwable)e);
            }
        }
        return false;
    }
}

