/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.UnableToValidateLicenseException;
import com.xebialabs.license.v1.License;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.HexEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseReader {
    private static final Logger log = LoggerFactory.getLogger(LicenseReader.class);
    private static final String SECURITY_PROVIDER = "BC";
    public static final String PUB_KEY = "308201b73082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a038184000281807096070ddc40ba6dc6b65fddf6c76d1cb8527aa075f08550174aa69abe9fda0994a649969ffb77dce5c92405abc7976646733f5f66295b16688c43a716045d2c861ec11df8063c2d0273da0149b95f7964c7e1b2b80576611aefbd4f0ea2e5bd41472d6b0d91be09e770203588c82523855aca42141bd555fba5f44df1d97dc8";
    public static final String LICENSE_PREAMBLE = "--- License V%s ---";
    public static final String SIGNATURE_ENDING = "--- End of Signature ---";
    public static final String SIGNATURE_PREAMBLE = "--- Signature (%s) ---";
    public static final Pattern LICENSE_PREAMBLE_REGEXP = Pattern.compile("^--- License V(\\d+) ---$", 8);
    public static final Charset LICENSE_FILE_ENCODING = Charsets.UTF_8;

    private static String readFileToString(File file) throws IOException {
        return CharStreams.toString((InputSupplier)Files.newReaderSupplier((File)file, (Charset)LICENSE_FILE_ENCODING));
    }

    public static byte[] readKey(String data) throws IOException {
        HexEncoder hexit = new HexEncoder();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hexit.decode(data, (OutputStream)bos);
        return bos.toByteArray();
    }

    public static License readLicense(File licenseFile) {
        LicenseVersionAndData licenseData = LicenseReader.readLicenseData(licenseFile);
        License license = null;
        if (!"1".equals(licenseData.version)) {
            throw new InvalidLicenseException(String.format("Unrecognized license version '%s' in license file %s", licenseData.version, licenseFile));
        }
        license = new License();
        String[] lines = licenseData.data.split("\r?\n");
        Pattern p = Pattern.compile("^([^:]+):\\s+(.+)$");
        for (String line : lines) {
            String value;
            Matcher matches = p.matcher(line);
            if (!matches.matches()) {
                throw new InvalidLicenseException(String.format("Unrecognized line '%s' in license file %s", line, licenseFile));
            }
            String key = matches.group(1);
            if (license.setProperty(key, value = matches.group(2))) continue;
            throw new InvalidLicenseException(String.format("Unknown key '%s' in license file %s", key, licenseFile));
        }
        try {
            license.validate();
            return license;
        }
        catch (NullPointerException ex) {
            throw new InvalidLicenseException(String.format("Invalid value in license file %s, %s", licenseFile, ex.getMessage()));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidLicenseException(String.format("Invalid value in license file %s, %s", licenseFile, ex.getMessage()));
        }
    }

    public static LicenseVersionAndData readLicenseData(File licenseFile) {
        try {
            Signature sig = Signature.getInstance("SHA1withDSA", SECURITY_PROVIDER);
            KeyFactory kf = KeyFactory.getInstance("DSA", SECURITY_PROVIDER);
            PublicKey publicKey = kf.generatePublic(new X509EncodedKeySpec(LicenseReader.readKey(PUB_KEY)));
            sig.initVerify(publicKey);
            String data = LicenseReader.readFileToString(licenseFile);
            log.debug("License file {} contents: {}", (Object)licenseFile, (Object)data);
            String lineEnding = data.contains("\r\n") ? "\r\n" : "\n";
            Matcher versionMatcher = LICENSE_PREAMBLE_REGEXP.matcher(data);
            if (!versionMatcher.find()) {
                throw new InvalidLicenseException(String.format("License file '%s' missing preamble", licenseFile));
            }
            String licenseVersion = versionMatcher.group(1);
            log.info("Reading version {} license file", (Object)licenseVersion);
            String sigPreamble = String.format(SIGNATURE_PREAMBLE, sig.getAlgorithm()) + lineEnding;
            int sigOffset = data.indexOf(sigPreamble);
            if (sigOffset == -1) {
                throw new InvalidLicenseException(String.format("License file '%s' missing signature start", licenseFile));
            }
            int terminatorOffset = data.indexOf(SIGNATURE_ENDING + lineEnding);
            if (terminatorOffset == -1) {
                throw new InvalidLicenseException(String.format("License file '%s' missing signature terminator", licenseFile));
            }
            int preambleLength = versionMatcher.end() + lineEnding.length();
            int licensePreambleLength = sigPreamble.length();
            String licenseContent = data.substring(preambleLength, sigOffset);
            String signature = data.substring(sigOffset + licensePreambleLength, terminatorOffset);
            log.debug("License content length: {} Signature length: {}", (Object)licenseContent.length(), (Object)signature.length());
            sig.update(licenseContent.getBytes(LICENSE_FILE_ENCODING));
            byte[] sigdata = LicenseReader.readKey(signature);
            if (!sig.verify(sigdata)) {
                throw new InvalidLicenseException(String.format("License file '%s' is not valid. Signature could not be verified.", licenseFile));
            }
            return new LicenseVersionAndData(licenseVersion, licenseContent);
        }
        catch (NoSuchProviderException e) {
            log.error("Security Provider not found. Installed providers: {} (Error: {})", (Object)Security.getProviders(), (Object)e.getMessage());
            throw new UnableToValidateLicenseException(String.format("Unable to validate license file '%s'", licenseFile), e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Algorithm not found. Available algorithms: {}", Security.getAlgorithms("Signature"));
            throw new UnableToValidateLicenseException(String.format("Unable to validate license file '%s'", licenseFile), e);
        }
        catch (InvalidKeySpecException e) {
            throw new UnableToValidateLicenseException(String.format("Could not read key while checking license file '%s'", licenseFile), e);
        }
        catch (InvalidKeyException e) {
            throw new UnableToValidateLicenseException(String.format("Invalid key while checking license file '%s'", licenseFile), e);
        }
        catch (SignatureException e) {
            throw new InvalidLicenseException(String.format("Unable to read signature from license file '%s'", licenseFile), e);
        }
        catch (IOException e) {
            throw new InvalidLicenseException(String.format("Unable to read license file '%s'", licenseFile), e);
        }
    }

    private static final class LicenseVersionAndData {
        public final String version;
        public final String data;

        public LicenseVersionAndData(String version, String data) {
            this.version = version;
            this.data = data;
        }
    }
}

