/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.UShort;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class DefaultExtraField
extends ExtraField {
    private final short headerId;
    @CheckForNull
    private byte[] data;

    DefaultExtraField(int headerId) {
        assert (UShort.check(headerId));
        this.headerId = (short)headerId;
    }

    @Override
    int getHeaderId() {
        return this.headerId & 0xFFFF;
    }

    @Override
    int getDataSize() {
        byte[] data = this.data;
        return null != data ? data.length : 0;
    }

    @Override
    void readFrom(byte[] src, int off, int size) {
        assert (UShort.check(size));
        this.data = new byte[size];
        System.arraycopy(src, off, this.data, 0, size);
    }

    @Override
    void writeTo(byte[] dst, int off) {
        byte[] src = this.data;
        if (null != src) {
            System.arraycopy(src, 0, dst, off, src.length);
        }
    }
}

