/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class ConnectionOptions {
    public static final String OPERATING_SYSTEM = "os";
    public static final String TEMPORARY_DIRECTORY_PATH = "tmp";
    public static final String TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = "tmpDeleteOnDisconnect";
    public static final boolean DEFAULT_TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = true;
    public static final String TEMPORARY_FILE_CREATION_RETRIES = "tmpFileCreationRetries";
    public static final int DEFAULT_TEMPORARY_FILE_CREATION_RETRIES = 100;
    public static final String CONNECTION_TIMEOUT_MILLIS = "connectionTimeoutMillis";
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 120000;
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String JUMPSTATION = "jumpstation";
    private final Map<String, Object> options;
    private static final ImmutableSet<String> filteredKeys = ImmutableSet.of((Object)"password", (Object)"passphrase");

    public ConnectionOptions() {
        this.options = Maps.newHashMap();
    }

    public ConnectionOptions(ConnectionOptions options) {
        this.options = Maps.newHashMap(options.options);
    }

    public void set(String key, Object value) {
        this.options.put(key, value);
    }

    public <T> T get(String key) throws IllegalArgumentException {
        Object value = this.options.get(key);
        if (value == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        return (T)value;
    }

    public <T> T getOptional(String key) {
        return (T)this.options.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        if (this.options.containsKey(key)) {
            return (T)this.options.get(key);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        Object o = this.options.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new IllegalArgumentException("Value specified for required connection option " + key + " is neither a Boolean nor a String");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.options.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new IllegalArgumentException("Value specified for connection option " + key + " is neither a Boolean nor a String");
    }

    public int getInteger(String key) {
        Object o = this.options.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Value specified for required connection option " + key + " is neither an Integer nor a String");
    }

    public int getInteger(String key, int defaultValue) {
        Object o = this.options.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Value specified for connection option " + key + " is neither an Integer nor a String");
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClazz) {
        Object o = this.options.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        if (o.getClass().equals(enumClazz)) {
            return (T)((Enum)o);
        }
        if (o instanceof String) {
            return Enum.valueOf(enumClazz, (String)o);
        }
        throw new IllegalArgumentException("Value specified for required connection option " + key + " is neither an " + enumClazz.getName() + " nor a String");
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClazz, T defaultValue) {
        Object o = this.options.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o.getClass().equals(enumClazz)) {
            return (T)((Enum)o);
        }
        if (o instanceof String) {
            return Enum.valueOf(enumClazz, (String)o);
        }
        throw new IllegalArgumentException("Value specified for connection option " + key + " is neither an instanceof of " + enumClazz.getName() + " nor a String");
    }

    public boolean containsKey(String key) {
        return this.options.containsKey(key);
    }

    public Set<String> keys() {
        return this.options.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionOptions that = (ConnectionOptions)o;
        return ((Object)this.options).equals(that.options);
    }

    public int hashCode() {
        return ((Object)this.options).hashCode();
    }

    public String toString() {
        return ConnectionOptions.print(this, "");
    }

    private static String print(ConnectionOptions options, String indent) {
        StringBuilder b = new StringBuilder();
        b.append("ConnectionOptions[\n");
        for (Map.Entry<String, Object> e : options.options.entrySet()) {
            b.append(indent).append("\t").append(e.getKey()).append(" --> ");
            Object value = e.getValue();
            if (value instanceof ConnectionOptions) {
                b.append(ConnectionOptions.print((ConnectionOptions)value, indent + "\t"));
            } else {
                b.append(filteredKeys.contains((Object)e.getKey()) ? "********" : value);
            }
            b.append("\n");
        }
        b.append(indent).append("]");
        return b.toString();
    }
}

