/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.model.AntiSamyPattern;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Property;
import org.owasp.validator.html.model.Tag;
import org.owasp.validator.html.scan.Constants;
import org.owasp.validator.html.util.URIUtils;
import org.owasp.validator.html.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Policy {
    public static final Pattern ANYTHING_REGEXP = Pattern.compile(".*");
    private static final String DEFAULT_POLICY_URI = "resources/antisamy.xml";
    private static final String DEFAULT_ONINVALID = "removeAttribute";
    public static final int DEFAULT_MAX_INPUT_SIZE = 100000;
    public static final int DEFAULT_MAX_STYLESHEET_IMPORTS = 1;
    public static final String OMIT_XML_DECLARATION = "omitXmlDeclaration";
    public static final String OMIT_DOCTYPE_DECLARATION = "omitDoctypeDeclaration";
    public static final String MAX_INPUT_SIZE = "maxInputSize";
    public static final String USE_XHTML = "useXHTML";
    public static final String FORMAT_OUTPUT = "formatOutput";
    public static final String EMBED_STYLESHEETS = "embedStyleSheets";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String ANCHORS_NOFOLLOW = "nofollowAnchors";
    public static final String VALIDATE_PARAM_AS_EMBED = "validateParamAsEmbed";
    public static final String PRESERVE_SPACE = "preserveSpace";
    public static final String PRESERVE_COMMENTS = "preserveComments";
    public static final String ENTITY_ENCODE_INTL_CHARS = "entityEncodeIntlChars";
    public static final String ENCODE_TAGS = "onUnknownTag";
    public static final String ACTION_VALIDATE = "validate";
    public static final String ACTION_FILTER = "filter";
    public static final String ACTION_TRUNCATE = "truncate";
    private static char REGEXP_BEGIN = (char)94;
    private static char REGEXP_END = (char)36;
    private HashMap commonRegularExpressions = new HashMap();
    private HashMap commonAttributes = new HashMap();
    private HashMap tagRules = new HashMap();
    private HashMap cssRules = new HashMap();
    private HashMap directives = new HashMap();
    private HashMap globalAttributes = new HashMap();
    private Set encodeTags = new HashSet();
    private ArrayList tagNames;
    private ArrayList allowedEmptyTags;
    private static URL baseUrl = null;

    public boolean isTagInListToEncode(String s) {
        return this.encodeTags.contains(s);
    }

    public Tag getTagByName(String tagName) {
        return (Tag)this.tagRules.get(tagName.toLowerCase());
    }

    public Property getPropertyByName(String propertyName) {
        return (Property)this.cssRules.get(propertyName.toLowerCase());
    }

    public static Policy getInstance() throws PolicyException {
        return Policy.getInstance(DEFAULT_POLICY_URI);
    }

    public static Policy getInstance(String filename) throws PolicyException {
        File file = new File(filename);
        return Policy.getInstance(file);
    }

    public static Policy getInstance(File file) throws PolicyException {
        try {
            URI uri = file.toURI();
            return Policy.getInstance(uri.toURL());
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
    }

    public static Policy getInstance(URL url) throws PolicyException {
        if (baseUrl == null) {
            Policy.setBaseURL(url);
        }
        return new Policy(url);
    }

    public static Policy getInstance(InputStream inputStream) throws PolicyException {
        return new Policy(inputStream);
    }

    private Policy(URL url) throws PolicyException {
        try {
            InputSource source = this.resolveEntity(null, url.toExternalForm());
            if (source == null) {
                source = new InputSource(url.toExternalForm());
                source.setByteStream(url.openStream());
            } else {
                source.setSystemId(url.toExternalForm());
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = null;
            dom = db.parse(source);
            Element topLevelElement = dom.getDocumentElement();
            NodeList includes = topLevelElement.getElementsByTagName("include");
            for (int i = 0; i < includes.getLength(); ++i) {
                Element include = (Element)includes.item(i);
                String href = XMLUtil.getAttributeValue(include, "href");
                Element includedPolicy = this.getPolicy(href);
                this.parsePolicy(includedPolicy);
            }
            this.parsePolicy(topLevelElement);
        }
        catch (SAXException e) {
            throw new PolicyException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
    }

    private Policy(InputStream is) throws PolicyException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = null;
            dom = db.parse(is);
            Element topLevelElement = dom.getDocumentElement();
            this.parsePolicy(topLevelElement);
        }
        catch (SAXException e) {
            throw new PolicyException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
    }

    private void parsePolicy(Element topLevelElement) throws PolicyException {
        if (topLevelElement == null) {
            return;
        }
        Element commonRegularExpressionListNode = (Element)topLevelElement.getElementsByTagName("common-regexps").item(0);
        this.parseCommonRegExps(commonRegularExpressionListNode);
        Element directiveListNode = (Element)topLevelElement.getElementsByTagName("directives").item(0);
        this.parseDirectives(directiveListNode);
        Element commonAttributeListNode = (Element)topLevelElement.getElementsByTagName("common-attributes").item(0);
        this.parseCommonAttributes(commonAttributeListNode);
        Element globalAttributeListNode = (Element)topLevelElement.getElementsByTagName("global-tag-attributes").item(0);
        this.parseGlobalAttributes(globalAttributeListNode);
        NodeList tagsToEncodeList = topLevelElement.getElementsByTagName("tags-to-encode");
        if (tagsToEncodeList != null && tagsToEncodeList.getLength() != 0) {
            this.parseTagsToEncode((Element)tagsToEncodeList.item(0));
        }
        Element allowedEmptyTagsListNode = (Element)topLevelElement.getElementsByTagName("allowed-empty-tags").item(0);
        this.allowedEmptyTags = this.parseAllowedEmptyTags(allowedEmptyTagsListNode);
        Element tagListNode = (Element)topLevelElement.getElementsByTagName("tag-rules").item(0);
        this.parseTagRules(tagListNode);
        Element cssListNode = (Element)topLevelElement.getElementsByTagName("css-rules").item(0);
        this.parseCSSRules(cssListNode);
    }

    private Element getPolicy(String href) throws IOException, SAXException, ParserConfigurationException {
        InputSource source = null;
        if (href != null && baseUrl != null) {
            String absURL;
            URL url;
            try {
                url = new URL(baseUrl, href);
                source = new InputSource(url.openStream());
                source.setSystemId(href);
            }
            catch (MalformedURLException except) {
                try {
                    absURL = URIUtils.resolveAsString(href, baseUrl.toString());
                    url = new URL(absURL);
                    source = new InputSource(url.openStream());
                    source.setSystemId(href);
                }
                catch (MalformedURLException ex2) {}
            }
            catch (FileNotFoundException fnfe) {
                try {
                    absURL = URIUtils.resolveAsString(href, baseUrl.toString());
                    url = new URL(absURL);
                    source = new InputSource(url.openStream());
                    source.setSystemId(href);
                }
                catch (MalformedURLException ex2) {
                    // empty catch block
                }
            }
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = null;
        if (source != null) {
            dom = db.parse(source);
            Element topLevelElement = dom.getDocumentElement();
            return topLevelElement;
        }
        return null;
    }

    private void parseDirectives(Element root) {
        if (root == null) {
            return;
        }
        NodeList directiveNodes = root.getElementsByTagName("directive");
        for (int i = 0; i < directiveNodes.getLength(); ++i) {
            Element ele = (Element)directiveNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            String value = XMLUtil.getAttributeValue(ele, "value");
            this.directives.put(name, value);
        }
    }

    private ArrayList parseAllowedEmptyTags(Element allowedEmptyTagsListNode) throws PolicyException {
        ArrayList allowedEmptyTags = new ArrayList();
        if (allowedEmptyTagsListNode != null) {
            Element literalListNode = (Element)allowedEmptyTagsListNode.getElementsByTagName("literal-list").item(0);
            if (literalListNode != null) {
                NodeList literalList = literalListNode.getElementsByTagName("literal");
                for (int j = 0; j < literalList.getLength(); ++j) {
                    Element literalNode = (Element)literalList.item(j);
                    String value = XMLUtil.getAttributeValue(literalNode, "value");
                    if (value == null || value.length() <= 0) continue;
                    allowedEmptyTags.add(value);
                }
            }
        } else {
            allowedEmptyTags = Constants.defaultAllowedEmptyTags;
        }
        return allowedEmptyTags;
    }

    private void parseTagsToEncode(Element root) throws PolicyException {
        if (root == null) {
            return;
        }
        NodeList tagsToEncodeNodes = root.getElementsByTagName("tag");
        if (tagsToEncodeNodes != null) {
            for (int i = 0; i < tagsToEncodeNodes.getLength(); ++i) {
                Element ele = (Element)tagsToEncodeNodes.item(i);
                if (ele.getFirstChild() == null || ele.getFirstChild().getNodeType() != 3) continue;
                this.encodeTags.add(ele.getFirstChild().getNodeValue());
            }
        }
    }

    private void parseGlobalAttributes(Element root) throws PolicyException {
        if (root == null) {
            return;
        }
        NodeList globalAttributeNodes = root.getElementsByTagName("attribute");
        for (int i = 0; i < globalAttributeNodes.getLength(); ++i) {
            Element ele = (Element)globalAttributeNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            Attribute toAdd = this.getCommonAttributeByName(name);
            if (toAdd == null) {
                throw new PolicyException("Global attribute '" + name + "' was not defined in <common-attributes>");
            }
            this.globalAttributes.put(name.toLowerCase(), toAdd);
        }
    }

    private void parseCommonRegExps(Element root) {
        if (root == null) {
            return;
        }
        NodeList commonRegExpPatternNodes = root.getElementsByTagName("regexp");
        for (int i = 0; i < commonRegExpPatternNodes.getLength(); ++i) {
            Element ele = (Element)commonRegExpPatternNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            Pattern pattern = Pattern.compile(XMLUtil.getAttributeValue(ele, "value"));
            this.commonRegularExpressions.put(name, new AntiSamyPattern(name, pattern));
        }
    }

    private void parseCommonAttributes(Element root) {
        if (root == null) {
            return;
        }
        NodeList commonAttributesNodes = root.getElementsByTagName("attribute");
        for (int i = 0; i < commonAttributesNodes.getLength(); ++i) {
            Element literalListNode;
            String value;
            Element ele = (Element)commonAttributesNodes.item(i);
            String onInvalid = XMLUtil.getAttributeValue(ele, "onInvalid");
            String name = XMLUtil.getAttributeValue(ele, "name");
            Attribute attribute = new Attribute(XMLUtil.getAttributeValue(ele, "name"));
            attribute.setDescription(XMLUtil.getAttributeValue(ele, "description"));
            if (onInvalid != null && onInvalid.length() > 0) {
                attribute.setOnInvalid(onInvalid);
            } else {
                attribute.setOnInvalid(DEFAULT_ONINVALID);
            }
            Element regExpListNode = (Element)ele.getElementsByTagName("regexp-list").item(0);
            if (regExpListNode != null) {
                NodeList regExpList = regExpListNode.getElementsByTagName("regexp");
                for (int j = 0; j < regExpList.getLength(); ++j) {
                    Element regExpNode = (Element)regExpList.item(j);
                    String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
                    value = XMLUtil.getAttributeValue(regExpNode, "value");
                    if (regExpName != null && regExpName.length() > 0) {
                        attribute.addAllowedRegExp(this.getRegularExpression(regExpName).getPattern());
                        continue;
                    }
                    attribute.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + value + REGEXP_END));
                }
            }
            if ((literalListNode = (Element)ele.getElementsByTagName("literal-list").item(0)) != null) {
                NodeList literalList = literalListNode.getElementsByTagName("literal");
                for (int j = 0; j < literalList.getLength(); ++j) {
                    Element literalNode = (Element)literalList.item(j);
                    value = XMLUtil.getAttributeValue(literalNode, "value");
                    if (value != null && value.length() > 0) {
                        attribute.addAllowedValue(value);
                        continue;
                    }
                    if (literalNode.getNodeValue() == null) continue;
                    attribute.addAllowedValue(literalNode.getNodeValue());
                }
            }
            this.commonAttributes.put(name.toLowerCase(), attribute);
        }
    }

    private void parseTagRules(Element root) throws PolicyException {
        if (root == null) {
            return;
        }
        NodeList tagList = root.getElementsByTagName("tag");
        for (int i = 0; i < tagList.getLength(); ++i) {
            Element tagNode = (Element)tagList.item(i);
            String name = XMLUtil.getAttributeValue(tagNode, "name");
            String action = XMLUtil.getAttributeValue(tagNode, "action");
            Tag tag = new Tag(name);
            if (this.tagNames == null) {
                this.tagNames = new ArrayList();
            }
            this.tagNames.add(name);
            tag.setAction(action);
            NodeList attributeList = tagNode.getElementsByTagName("attribute");
            for (int j = 0; j < attributeList.getLength(); ++j) {
                Element literalListNode;
                String value;
                Attribute attribute;
                Element attributeNode = (Element)attributeList.item(j);
                if (!attributeNode.hasChildNodes()) {
                    attribute = this.getCommonAttributeByName(XMLUtil.getAttributeValue(attributeNode, "name"));
                    if (attribute != null) {
                        String onInvalid = XMLUtil.getAttributeValue(attributeNode, "onInvalid");
                        String description = XMLUtil.getAttributeValue(attributeNode, "description");
                        if (onInvalid != null && onInvalid.length() != 0) {
                            attribute.setOnInvalid(onInvalid);
                        }
                        if (description != null && description.length() != 0) {
                            attribute.setDescription(description);
                        }
                        tag.addAttribute((Attribute)attribute.clone());
                        continue;
                    }
                    throw new PolicyException("Attribute '" + XMLUtil.getAttributeValue(attributeNode, "name") + "' was referenced as a common attribute in definition of '" + tag.getName() + "', but does not exist in <common-attributes>");
                }
                attribute = new Attribute(XMLUtil.getAttributeValue(attributeNode, "name"));
                attribute.setOnInvalid(XMLUtil.getAttributeValue(attributeNode, "onInvalid"));
                attribute.setDescription(XMLUtil.getAttributeValue(attributeNode, "description"));
                Element regExpListNode = (Element)attributeNode.getElementsByTagName("regexp-list").item(0);
                if (regExpListNode != null) {
                    NodeList regExpList = regExpListNode.getElementsByTagName("regexp");
                    for (int k = 0; k < regExpList.getLength(); ++k) {
                        Element regExpNode = (Element)regExpList.item(k);
                        String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
                        value = XMLUtil.getAttributeValue(regExpNode, "value");
                        if (regExpName != null && regExpName.length() > 0) {
                            AntiSamyPattern pattern = this.getRegularExpression(regExpName);
                            if (pattern != null) {
                                attribute.addAllowedRegExp(pattern.getPattern());
                                continue;
                            }
                            throw new PolicyException("Regular expression '" + regExpName + "' was referenced as a common regexp in definition of '" + tag.getName() + "', but does not exist in <common-regexp>");
                        }
                        if (value == null || value.length() <= 0) continue;
                        attribute.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + value + REGEXP_END));
                    }
                }
                if ((literalListNode = (Element)attributeNode.getElementsByTagName("literal-list").item(0)) != null) {
                    NodeList literalList = literalListNode.getElementsByTagName("literal");
                    for (int k = 0; k < literalList.getLength(); ++k) {
                        Element literalNode = (Element)literalList.item(k);
                        value = XMLUtil.getAttributeValue(literalNode, "value");
                        if (value != null && value.length() > 0) {
                            attribute.addAllowedValue(value);
                            continue;
                        }
                        if (literalNode.getNodeValue() == null) continue;
                        attribute.addAllowedValue(literalNode.getNodeValue());
                    }
                }
                tag.addAttribute(attribute);
            }
            this.tagRules.put(name.toLowerCase(), tag);
        }
    }

    private void parseCSSRules(Element root) throws PolicyException {
        if (root == null) {
            return;
        }
        NodeList propertyNodes = root.getElementsByTagName("property");
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Element shorthandListNode;
            Element literalListNode;
            Element ele = (Element)propertyNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            String description = XMLUtil.getAttributeValue(ele, "description");
            Property property = new Property(name);
            property.setDescription(description);
            String onInvalid = XMLUtil.getAttributeValue(ele, "onInvalid");
            if (onInvalid != null && onInvalid.length() > 0) {
                property.setOnInvalid(onInvalid);
            } else {
                property.setOnInvalid(DEFAULT_ONINVALID);
            }
            Element regExpListNode = (Element)ele.getElementsByTagName("regexp-list").item(0);
            if (regExpListNode != null) {
                NodeList regExpList = regExpListNode.getElementsByTagName("regexp");
                for (int j = 0; j < regExpList.getLength(); ++j) {
                    Element regExpNode = (Element)regExpList.item(j);
                    String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
                    String value = XMLUtil.getAttributeValue(regExpNode, "value");
                    AntiSamyPattern pattern = this.getRegularExpression(regExpName);
                    if (pattern != null) {
                        property.addAllowedRegExp(pattern.getPattern());
                        continue;
                    }
                    if (value != null) {
                        property.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + value + REGEXP_END));
                        continue;
                    }
                    throw new PolicyException("Regular expression '" + regExpName + "' was referenced as a common regexp in definition of '" + property.getName() + "', but does not exist in <common-regexp>");
                }
            }
            if ((literalListNode = (Element)ele.getElementsByTagName("literal-list").item(0)) != null) {
                NodeList literalList = literalListNode.getElementsByTagName("literal");
                for (int j = 0; j < literalList.getLength(); ++j) {
                    Element literalNode = (Element)literalList.item(j);
                    property.addAllowedValue(XMLUtil.getAttributeValue(literalNode, "value"));
                }
            }
            if ((shorthandListNode = (Element)ele.getElementsByTagName("shorthand-list").item(0)) != null) {
                NodeList shorthandList = shorthandListNode.getElementsByTagName("shorthand");
                for (int j = 0; j < shorthandList.getLength(); ++j) {
                    Element shorthandNode = (Element)shorthandList.item(j);
                    property.addShorthandRef(XMLUtil.getAttributeValue(shorthandNode, "name"));
                }
            }
            this.cssRules.put(name.toLowerCase(), property);
        }
    }

    public AntiSamyPattern getRegularExpression(String name) {
        return (AntiSamyPattern)this.commonRegularExpressions.get(name);
    }

    public Attribute getGlobalAttributeByName(String name) {
        return (Attribute)this.globalAttributes.get(name.toLowerCase());
    }

    private Attribute getCommonAttributeByName(String attributeName) {
        return (Attribute)this.commonAttributes.get(attributeName.toLowerCase());
    }

    public String[] getAllowedEmptyTags() {
        return this.allowedEmptyTags.toArray(new String[this.allowedEmptyTags.size()]);
    }

    public String[] getTags() {
        return this.tagNames.toArray(new String[1]);
    }

    public String getDirective(String name) {
        return (String)this.directives.get(name);
    }

    public void setDirective(String name, String value) {
        this.directives.put(name, value);
    }

    public int getMaxInputSize() {
        int maxInputSize = 100000;
        try {
            maxInputSize = Integer.parseInt(this.getDirective(MAX_INPUT_SIZE));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxInputSize;
    }

    public static void setBaseURL(URL newValue) {
        baseUrl = newValue;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource source = null;
        if (systemId != null && baseUrl != null) {
            try {
                URL url = new URL(baseUrl, systemId);
                source = new InputSource(url.openStream());
                source.setSystemId(systemId);
                return source;
            }
            catch (MalformedURLException except) {
                try {
                    String absURL = URIUtils.resolveAsString(systemId, baseUrl.toString());
                    URL url = new URL(absURL);
                    source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException ex2) {
                }
            }
            catch (FileNotFoundException fnfe) {
                try {
                    String absURL = URIUtils.resolveAsString(systemId, baseUrl.toString());
                    URL url = new URL(absURL);
                    source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException ex2) {
                    // empty catch block
                }
            }
            return null;
        }
        return null;
    }
}

