package com.xebialabs.xldeploy.auth

import org.springframework.security.core.context.SecurityContext
import org.springframework.security.web.context.HttpSessionSecurityContextRepository

import javax.servlet.http.{HttpServletRequest, HttpServletResponse}

class BasicAuthOverridingHttpSessionSecurityContextRepository extends HttpSessionSecurityContextRepository {
  override def saveContext(context: SecurityContext, request: HttpServletRequest, response: HttpServletResponse): Unit = {
    if (isBasicAuth(request) && !isWebSocketUpgrading(request)) {
      val session = request.getSession(false)
      if (session != null) { // force fully logout the session to ensure isolation.
        session.invalidate()
      }
      return
    }
    super.saveContext(context, request, response)
  }

  private def isWebSocketUpgrading(request: HttpServletRequest) = request.getPathInfo != null && request.getPathInfo.startsWith("/ws/")

  private def isBasicAuth(request: HttpServletRequest) = {
    val authorization = request.getHeader("Authorization")
    authorization != null && authorization.contains("Basic ")
  }
}
