package com.xebialabs.xldeploy.auth.config

import ai.digital.config.ServerConfigurationHelper
import org.springframework.security.access.AccessDecisionVoter
import org.springframework.security.access.ConfigAttribute
import org.springframework.security.core.Authentication
import org.springframework.security.core.authority.SimpleGrantedAuthority

import java.util

class CentralConfigVoterAdapter(adapted: AccessDecisionVoter[AnyRef]) extends AccessDecisionVoter[AnyRef] {

  val ConfigRoleGrantedAuthority: SimpleGrantedAuthority = new SimpleGrantedAuthority(s"ROLE_${ServerConfigurationHelper.ConfigRole}")

  override def supports(attribute: ConfigAttribute): Boolean = adapted.supports(attribute)

  override def supports(clazz: Class[_]): Boolean = adapted.supports(clazz)

  override def vote(authentication: Authentication, `object`: AnyRef, attributes: util.Collection[ConfigAttribute]): Int = {
    if (authentication.isAuthenticated && authentication.getAuthorities.contains(ConfigRoleGrantedAuthority)) {
      AccessDecisionVoter.ACCESS_GRANTED
    } else {
      adapted.vote(authentication, `object`, attributes)
    }
  }
}
