package com.xebialabs.xldeploy.auth.config

import ai.digital.config.ServerConfigurationHelper
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder
import org.springframework.security.crypto.password.NoOpPasswordEncoder

/**
 * In memory configurer for providing config admin user
 */
object InMemoryConfigurer {

  def configure(auth: AuthenticationManagerBuilder): Unit = {
    val inMemoryConfigurer = auth.inMemoryAuthentication()
      .passwordEncoder(NoOpPasswordEncoder.getInstance())
    inMemoryConfigurer
      .withUser(ServerConfigurationHelper.ConfigAdminUser)
      .password(ServerConfigurationHelper.getAdminPassword.getOrElse(""))
      .credentialsExpired(false)
      .accountExpired(false)
      .accountLocked(false)
      .roles(ServerConfigurationHelper.ConfigRole);
  }

}
