package com.xebialabs.xldeploy.auth

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.security.{PermissionEnforcer, RoleService, UserService}
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.security.core.authority.SimpleGrantedAuthority
import org.springframework.security.core.userdetails.{User, UserDetailsService, UsernameNotFoundException}
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

@ConditionalOnProperty(name = Array("deploy.server.security.auth.provider"), havingValue = "default", matchIfMissing = true)
@Service
class SqlUserDetailsService(userService: UserService, roleService: RoleService) extends UserDetailsService {

  private def loadAuthorities(username: String) = {
    val user = userService.read(username)
    val isAdmin = user.isAdmin || "admin".equals(user.getUsername)
    val explicitRoles = if (isAdmin) PermissionEnforcer.ROLE_ADMIN :: Nil else Nil
    roleService
      .getRolesFor(username, null, null, null)
      .asScala
      .map(_.getId)
      .toList
      .:::(explicitRoles)
      .map(new SimpleGrantedAuthority(_))
  }

  override def loadUserByUsername(username: String): User = Try(new User(username, "", loadAuthorities(username).asJava)) match {
    case Success(value) => value
    case Failure(exception: NotFoundException) => throw new UsernameNotFoundException(exception.getMessage, exception)
    case Failure(exception) => throw exception
  }
}
