package com.xebialabs.xldeploy.auth.config

import ai.digital.config.ServerConfigurationHelper
import org.springframework.security.authentication.dao.DaoAuthenticationProvider
import org.springframework.security.core.userdetails.User
import org.springframework.security.crypto.password.NoOpPasswordEncoder
import org.springframework.security.provisioning.InMemoryUserDetailsManager

/**
 * In memory configurer for providing config admin user
 */
object InMemoryConfigurer {

  def centralConfigDaoProvider : DaoAuthenticationProvider = {
    val user = User.builder().passwordEncoder(NoOpPasswordEncoder.getInstance().encode)
      .username(ServerConfigurationHelper.ConfigAdminUser)
      .password(ServerConfigurationHelper.getAdminPassword.getOrElse(""))
      .roles(ServerConfigurationHelper.ConfigRole)
      .credentialsExpired(false)
      .accountExpired(false)
      .accountLocked(false)
      .build
    val centralConfigProvider = new DaoAuthenticationProvider()
    centralConfigProvider.setUserDetailsService(new InMemoryUserDetailsManager(user))
    centralConfigProvider.setPasswordEncoder(NoOpPasswordEncoder.getInstance())
    centralConfigProvider
  }

}
