package com.xebialabs.xldeploy.auth

import org.springframework.security.authentication.{AuthenticationServiceException, InternalAuthenticationServiceException}
import org.springframework.security.core.{Authentication, AuthenticationException}
import org.springframework.security.ldap.authentication.{LdapAuthenticationProvider, LdapAuthenticator}
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator

class DeployLdapAuthenticationProvider(authenticator: LdapAuthenticator, authoritiesPopulator: LdapAuthoritiesPopulator)
  extends LdapAuthenticationProvider(authenticator, authoritiesPopulator) {

  @throws[AuthenticationException]
  override def authenticate(authentication: Authentication): Authentication =
    try
      super.authenticate(authentication)
    catch {
      case e: InternalAuthenticationServiceException =>
        logger.error("Exception occurred in Ldap Authentication ", e)
        throw new AuthenticationServiceException(e.getMessage, e.getCause)
  }
}
