/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserTokenService;
import com.xebialabs.xldeploy.auth.TokenExpiredException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\t\u0013\u0001uA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006\u00011A\u0005\neCq\u0001\u001a\u0001A\u0002\u0013%Q\r\u0003\u0004o\u0001\u0001\u0006KA\u0017\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006o\u0002!I\u0001\u001f\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!\u0011\u0001\t\u0013\t\u0019\u0005\u0003\u0004\u0002d\u0001!\t!\u0017\u0005\b\u0003K\u0002A\u0011AA4\u0005q!U\r\u001d7ps\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJT!a\u0005\u000b\u0002\r\r|gNZ5h\u0015\t)b#\u0001\u0003bkRD'BA\f\u0019\u0003!AH\u000eZ3qY>L(BA\r\u001b\u0003%AXMY5bY\u0006\u00147OC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aD\n\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019y%M[3diB\u0011q\u0005M\u0007\u0002Q)\u0011\u0011FK\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tYC&\u0001\u0005tK\u000e,(/\u001b;z\u0015\tic&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005y\u0013aA8sO&\u0011\u0011\u0007\u000b\u0002\u0017\u0003V$\b.\u001a8uS\u000e\fG/[8o!J|g/\u001b3fe\u0006YQo]3s'\u0016\u0014h/[2f!\t!\u0004(D\u00016\u0015\tYcG\u0003\u000281\u0005AA-\u001a9m_fLG/\u0003\u0002:k\tYQk]3s'\u0016\u0014h/[2f\u0003A)8/\u001a:U_.,gnU3sm&\u001cW\r\u0005\u0002=\u007f5\tQH\u0003\u0002?k\u000591/\u001a:wS\u000e,\u0017B\u0001!>\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u000bqe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015+\u0014!\u00049sS:\u001c\u0017\u000e]1mI\u0006$\u0018-\u0003\u0002H\t\n)\u0002K]5oG&\u0004\u0018\r\u001c#bi\u0006\u0004&o\u001c<jI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003K\u00196s\u0005CA&\u0001\u001b\u0005\u0011\u0002\"\u0002\u001a\u0005\u0001\u0004\u0019\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0004\"B!\u0005\u0001\u0004\u0011\u0015A\u00027pO\u001e,'/F\u0001R!\t\u0011V+D\u0001T\u0015\t!f&A\u0003tY\u001a$$.\u0003\u0002W'\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\tbkRDwN]5uS\u0016\u001cX*\u00199qKJ,\u0012A\u0017\t\u00037\nl\u0011\u0001\u0018\u0006\u0003;z\u000bq!\\1qa&twM\u0003\u0002`A\u0006I\u0011-\u001e;i_JLG/\u001f\u0006\u0003C*\nAaY8sK&\u00111\r\u0018\u0002\u0019\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7/T1qa\u0016\u0014\u0018!F1vi\"|'/\u001b;jKNl\u0015\r\u001d9fe~#S-\u001d\u000b\u0003M2\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014A!\u00168ji\"9Q\u000eCA\u0001\u0002\u0004Q\u0016a\u0001=%c\u0005\u0011\u0012-\u001e;i_JLG/[3t\u001b\u0006\u0004\b/\u001a:!\u00031\tW\u000f\u001e5f]RL7-\u0019;f)\t\tX\u000f\u0005\u0002sg6\t\u0001-\u0003\u0002uA\nq\u0011)\u001e;iK:$\u0018nY1uS>t\u0007\"\u0002<\u000b\u0001\u0004\t\u0018!\u0002;pW\u0016t\u0017!G1vi\",g\u000e^5dCR,gI]8n+N,'\u000fV8lK:$\"!]=\t\u000bY\\\u0001\u0019\u0001>\u0011\u0007m\f)AD\u0002}\u0003\u0003\u0001\"! 5\u000e\u0003yT!a \u000f\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0001[\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r\u0001.A\u000ebkRDWM\u001c;jG\u0006$XM\u0012:p[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0006c\u0006=\u00111\u0003\u0005\u0007\u0003#a\u0001\u0019\u0001>\u0002\u0011U\u001cXM\u001d8b[\u0016Da!!\u0006\r\u0001\u0004Q\u0018\u0001\u00039bgN<xN\u001d3\u0002\u0011M,\b\u000f]8siN$B!a\u0007\u0002\"A\u0019q-!\b\n\u0007\u0005}\u0001NA\u0004C_>dW-\u00198\t\r%j\u0001\u0019AA\u0012a\u0011\t)#a\f\u0011\u000bm\f9#a\u000b\n\t\u0005%\u0012\u0011\u0002\u0002\u0006\u00072\f7o\u001d\t\u0005\u0003[\ty\u0003\u0004\u0001\u0005\u0019\u0005E\u0012\u0011EA\u0001\u0002\u0003\u0015\t!a\r\u0003\u0007}#3'\u0005\u0003\u00026\u0005m\u0002cA4\u00028%\u0019\u0011\u0011\b5\u0003\u000f9{G\u000f[5oOB\u0019q-!\u0010\n\u0007\u0005}\u0002NA\u0002B]f\f1#\u001a<bYV\fG/Z!vi\"|'/\u001b;jKN$B!!\u0012\u0002bA\"\u0011qIA+!\u0019\tI%a\u0014\u0002T5\u0011\u00111\n\u0006\u0004\u0003\u001b\u0012\u0013\u0001B;uS2LA!!\u0015\u0002L\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\u00055\u0012Q\u000b\u0003\f\u0003/r\u0011\u0011!A\u0001\u0006\u0003\tIFA\u0002`IQ\nB!!\u000e\u0002\\A\u0019!/!\u0018\n\u0007\u0005}\u0003M\u0001\tHe\u0006tG/\u001a3BkRDwN]5us\"1\u0011\u0011\u0003\bA\u0002i\fAcZ3u\u0003V$\bn\u001c:ji&,7/T1qa\u0016\u0014\u0018\u0001F:fi\u0006+H\u000f[8sSRLWm]'baB,'\u000fF\u0002g\u0003SBQ\u0001\u0017\tA\u0002iCs\u0001AA7\u0003s\nY\b\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019\bL\u0001\u000bgR,'/Z8usB,\u0017\u0002BA<\u0003c\u0012\u0011bQ8na>tWM\u001c;\u0002\u000bY\fG.^3\"\u0005\u0005u\u0014\u0001\u0007=m\u0003V$\b.\u001a8uS\u000e\fG/[8o!J|g/\u001b3fe\u0002")
public class DeployAuthenticationProvider
implements AuthenticationProvider {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final PrincipalDataProvider principalDataProvider;
    private final Logger logger;
    private GrantedAuthoritiesMapper authoritiesMapper;

    private Logger logger() {
        return this.logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) {
        Authentication authentication;
        this.logger().debug("Authenticating for Digital.ai Deploy");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace("Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        if (userToken == null) {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        }
        if (((Tokens)userToken.tokens().head()).isExpired()) {
            throw new TokenExpiredException("The token expired on " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(((Tokens)userToken.tokens().head()).expiryDate()));
        }
        this.userTokenService.updateLastUsedDate(Predef$.MODULE$.Integer2int(((Tokens)userToken.tokens().head()).ciId()), new Date());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)userToken.username(), token, ((Tokens)userToken.tokens().head()).expiryDate(), mappedAuthorities, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace("Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, mappedAuthorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider.getAuthorities(username));
        }
        User user = this.userService.read(username);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public DeployAuthenticationProvider(UserService userService, UserTokenService userTokenService, PrincipalDataProvider principalDataProvider) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.principalDataProvider = principalDataProvider;
        this.logger = LoggerFactory.getLogger(DeployAuthenticationProvider.class);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

