/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.filter.CsrfHeaderFilter;
import com.xebialabs.xldeploy.auth.config.DeploySecurityConfig;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import scala.reflect.ScalaSignature;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="default", matchIfMissing=true)
@Configuration
@EnableWebSecurity
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0007\u000f\u0001eAQA\b\u0001\u0005\u0002}A\u0011\"\t\u0001A\u0002\u0003\u0007I\u0011\u0001\u0012\t\u0013E\u0002\u0001\u0019!a\u0001\n\u0003\u0011\u0004\"C\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003$\u0011%9\u0005\u00011AA\u0002\u0013\u0005\u0001\nC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"I!\f\u0001a\u0001\u0002\u0003\u0006K!\u0013\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u00191\u0007\u0001)A\u0005=\")q\r\u0001C\u0001Q\"9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0002\u0019\t\u0016\u0004Hn\\=DgJ47+Z2ve&$\u0018pQ8oM&<'BA\b\u0011\u0003\u0019\u0019wN\u001c4jO*\u0011\u0011CE\u0001\u0005CV$\bN\u0003\u0002\u0014)\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011AD\u0005\u0003;9\u0011A\u0003R3qY>L8+Z2ve&$\u0018pQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0001!!\tY\u0002!A\bu_.,gNU3q_NLGo\u001c:z+\u0005\u0019\u0003C\u0001\u00130\u001b\u0005)#B\u0001\u0014(\u0003\u0011\u00197O\u001d4\u000b\u0005!J\u0013aA<fE*\u0011!fK\u0001\tg\u0016\u001cWO]5us*\u0011A&L\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta&A\u0002pe\u001eL!\u0001M\u0013\u0003=!#H\u000f]*fgNLwN\\\"te\u001a$vn[3o%\u0016\u0004xn]5u_JL\u0018a\u0005;pW\u0016t'+\u001a9pg&$xN]=`I\u0015\fHCA\u001a:!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0011)f.\u001b;\t\u000fi\u001a\u0011\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\u0002!Q|7.\u001a8SKB|7/\u001b;pef\u0004\u0003F\u0001\u0003>!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0006b]:|G/\u0019;j_:T!AQ\"\u0002\u000f\u0019\f7\r^8ss*\u0011AiK\u0001\u0006E\u0016\fgn]\u0005\u0003\r~\u0012\u0011\"Q;u_^L'/\u001a3\u0002'\rd\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003%\u0003\"AS+\u000e\u0003-S!\u0001T'\u0002\r\u0011,\u0007\u000f\\8z\u0015\tqu*A\u0004dK:$(/\u00197\u000b\u0005A\u000b\u0016!D2p]\u001aLw-\u001e:bi&|gN\u0003\u0002S'\u00069A-[4ji\u0006d'\"\u0001+\u0002\u0005\u0005L\u0017B\u0001,L\u0005A\u0019E.[3oiB\u0013x\u000e]3si&,7/A\fdY&,g\u000e^\"p]\u001aLw-\u001e:bi&|gn\u0018\u0013fcR\u00111'\u0017\u0005\bu\u0019\t\t\u00111\u0001J\u0003Q\u0019G.[3oi\u000e{gNZ5hkJ\fG/[8oA!\u0012q!P\u0001\u0007aJ,g-\u001b=\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0004TiJLgnZ\u0001\baJ,g-\u001b=!\u0003\u0015\u001aXmY;sSRLh)\u001b7uKJ\u001c\u0005.Y5o\u0007N\u0014hmU3dkJLG/_\"p]\u001aLw\r\u0006\u0002j[B\u0011!n[\u0007\u0002O%\u0011An\n\u0002\u0014'\u0016\u001cWO]5us\u001aKG\u000e^3s\u0007\"\f\u0017N\u001c\u0005\u0006]*\u0001\ra\\\u0001\u0005QR$\b\u000f\u0005\u0002qm6\t\u0011O\u0003\u0002sg\u0006A!-^5mI\u0016\u00148O\u0003\u0002)i*\u0011\u0001)\u001e\u0006\u0003\u001f%J!a^9\u0003\u0019!#H\u000f]*fGV\u0014\u0018\u000e^=)\u0005)I\bC\u0001>\u007f\u001b\u0005Y(B\u0001!}\u0015\ti8&A\u0004d_:$X\r\u001f;\n\u0005}\\(\u0001\u0002\"fC:DsACA\u0002\u0003#\t\u0019\u0002\u0005\u0003\u0002\u0006\u00055QBAA\u0004\u0015\r\u0001\u0015\u0011\u0002\u0006\u0004\u0003\u0017Y\u0013\u0001B2pe\u0016LA!a\u0004\u0002\b\t)qJ\u001d3fe\u0006)a/\u00197vKv\t\u0011\u0001K\u0003\u000b\u0003/\t)\u0004E\u00035\u00033\ti\"C\u0002\u0002\u001cU\u0012a\u0001\u001e5s_^\u001c\b\u0003BA\u0010\u0003_qA!!\t\u0002,9!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0007\u00055R'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\n\u000bb\u001cW\r\u001d;j_:T1!!\f6c\u001dq\u0012qGA#\u0003c\u0002B!!\u000f\u0002B9!\u00111HA\u001f!\r\t\u0019#N\u0005\u0004\u0003\u007f)\u0014A\u0002)sK\u0012,g-C\u0002f\u0003\u0007R1!a\u00106c%\u0019\u0013qIA(\u0003O\n\t&\u0006\u0003\u0002J\u0005-SCAA\u001c\t\u001d\ti\u0005\u0007b\u0001\u0003/\u0012\u0011\u0001V\u0005\u0005\u0003#\n\u0019&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003+*\u0014A\u0002;ie><8/\u0005\u0003\u0002Z\u0005}\u0003c\u0001\u001b\u0002\\%\u0019\u0011QL\u001b\u0003\u000f9{G\u000f[5oOB!\u0011\u0011MA2\u001d\r!\u00141F\u0005\u0005\u0003K\n\u0019DA\u0005UQJ|w/\u00192mKFJ1%!\u001b\u0002l\u00055\u0014Q\u000b\b\u0004i\u0005-\u0014bAA+kE*!\u0005N\u001b\u0002p\t)1oY1mCF\u001aa%!\b\u0002\u00191|wm\\;u\r&dG/\u001a:\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0007Y><w.\u001e;\u000b\u0007\u0005\u0005u%\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\r\u0019><w.\u001e;GS2$XM]\u0001\u001ao\u0016\u00147i\u001d:g'\u0016\u001cWO]5us\u000e+8\u000f^8nSj,'/\u0006\u0002\u0002\fB!\u0011QRAI\u001b\t\tyI\u0003\u0002Qg&!\u00111SAH\u0005U9VMY*fGV\u0014\u0018\u000e^=DkN$x.\\5{KJD#\u0001D=)\u001f\u0001\tI*!,\u00020\u0006U\u0016qWA^\u0003{\u0003B!a'\u0002*6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005d_:$\u0017\u000e^5p]*!\u00111UAS\u00035\tW\u000f^8d_:4\u0017nZ;sK*\u0019\u0011qU\u0016\u0002\t\t|w\u000e^\u0005\u0005\u0003W\u000biJA\u000bD_:$\u0017\u000e^5p]\u0006dwJ\u001c)s_B,'\u000f^=\u0002\t9\fW.\u001a\u0017\u0003\u0003c\u000b#!a-\u0002I\u0011,\u0007\u000f\\8z]M,'O^3s]M,7-\u001e:jift\u0013-\u001e;i]A\u0014xN^5eKJ\f1\u0002[1wS:<g+\u00197vK\u0006\u0012\u0011\u0011X\u0001\bI\u00164\u0017-\u001e7u\u00039i\u0017\r^2i\u0013\u001al\u0015n]:j]\u001eL\u0012!\u0001\u0015\u0004\u0001\u0005\u0005\u0007c\u0001>\u0002D&\u0019\u0011QY>\u0003\u001b\r{gNZ5hkJ\fG/[8oQ\r\u0001\u0011\u0011\u001a\t\u0005\u0003\u001b\u000bY-\u0003\u0003\u0002N\u0006=%!E#oC\ndWmV3c'\u0016\u001cWO]5us\u0002")
public class DeployCsrfSecurityConfig
extends DeploySecurityConfig {
    @Autowired
    private HttpSessionCsrfTokenRepository tokenRepository;
    @Autowired
    private ClientProperties clientConfiguration;
    private final String prefix;

    public HttpSessionCsrfTokenRepository tokenRepository() {
        return this.tokenRepository;
    }

    public void tokenRepository_$eq(HttpSessionCsrfTokenRepository x$1) {
        this.tokenRepository = x$1;
    }

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    private String prefix() {
        return this.prefix;
    }

    @Bean
    @Order(value=1)
    public SecurityFilterChain securityFilterChainCsrfSecurityConfig(HttpSecurity http) throws Exception {
        http.securityMatchers(securityMatcher -> securityMatcher.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)("/" + this.prefix() + "/**"))}));
        this.configureSecurity(http, this.prefix());
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName(null);
        return (SecurityFilterChain)http.addFilterAfter((Filter)new CsrfHeaderFilter(this.clientConfiguration()), CsrfFilter.class).addFilterBefore((Filter)this.logoutFilter(), LogoutFilter.class).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)this.tokenRepository()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler)).build();
    }

    private LogoutFilter logoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter((LogoutSuccessHandler)this.withoutRedirectLogoutSuccessHandler(), new LogoutHandler[]{new CsrfLogoutHandler((CsrfTokenRepository)this.tokenRepository()), new CookieClearingLogoutHandler(new String[]{"cookiesToClear", "XSRF-TOKEN"}), this.rememberMeServices(), new SecurityContextLogoutHandler()});
        logoutFilter.setFilterProcessesUrl("/xldeploy/logout");
        return logoutFilter;
    }

    @Bean
    public WebSecurityCustomizer webCsrfSecurityCustomizer() {
        return web -> this.configureSecurity(web, this.prefix());
    }

    public DeployCsrfSecurityConfig() {
        this.prefix = "xldeploy";
    }
}

