package com.xebialabs.xldeploy.auth.config

import ai.digital.deploy.sql.model.LoginProvider
import com.xebialabs.xldeploy.auth.DelegatingUserDetailsService
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.{Bean, Configuration, Primary}
import org.springframework.security.core.userdetails.UserDetailsService

@ConditionalOnProperty(name = Array("deploy.server.security.auth.provider"), havingValue = "default", matchIfMissing = true)
@Configuration
class SecurityResolutionConfiguration {

  @Bean @Primary
  def defaultUserDetailsService(applicationContext: ApplicationContext): UserDetailsService = {
    val services = applicationContext.getBeansOfType(classOf[UserDetailsService]).values()
    if (services.size() > 1) {
      new DelegatingUserDetailsService(services)
    } else {
      services.iterator().next()
    }
  }

  @Bean
  def loginProviderBean: LoginProvider = new LoginProvider("Local login", "/login", "/logout", true)

}
