package com.xebialabs.deployit.core.rest.api.reports.widgets;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.TopNLongestRunningReportLine;
import org.joda.time.DateTime;

import java.util.Collection;

import static com.xebialabs.deployit.core.util.CiUtils.getIdWithoutRoot;

public class Top10LongestRunningDeployments extends DashboardWidgetBase {
    private static final String DURATION = "duration";
    private static final String ENVIRONMENT = "environment";
    private static final String APPLICATION_NAME = "application";

    Top10LongestRunningDeployments(final TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(final DateTime beginDate, final DateTime endDate) {
        Collection<TopNLongestRunningReportLine> searchResult = taskArchive.topNLongestRunningDeployments(beginDate, endDate, TOP_N);
        return generateDurationReport(searchResult);
    }

    private Report generateDurationReport(final Collection<TopNLongestRunningReportLine> resultList) {
        Report report = new Report();
        resultList.forEach(rs -> {
            ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, rs.application());
            reportLine.addValue(ENVIRONMENT, getIdWithoutRoot(rs.environment()));
            reportLine.addValue(DURATION, formatToMinsAndSecs(rs.durationMillis()));
        });

        return report;
    }
}
