package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.task.archive.TaskArchive;

public enum WidgetRegistry {

    DEPLOYMENTSUCCESS("deploymentSuccess") {
        @Override
        public final Widget getWidget(final TaskArchive taskArchive) {
            return new DeploymentsPercentageWidgetData(taskArchive);
        }
    },
    DEPLOYMENTDURATION("deploymentDuration") {
        @Override
        public final Widget getWidget(final TaskArchive taskArchive) {
            return new DeploymentsDurationFrequencyWidget(taskArchive);
        }
    },
    DEPLOYMENTTREND("deploymentTrend") {
        @Override
        public Widget getWidget(final TaskArchive taskArchive) {
            return new DeploymentTrendsWidget(taskArchive);
        }
    },
    DEPLOYMENTTRENDPERCENTILE("deploymentTrendPercentile") {
        @Override
        public Widget getWidget(final TaskArchive taskArchive) {
            return new DeploymentTrendsPercentileWidget(taskArchive);
        }
    },
    TOP10SUCCESSFULDEPLOYMENTS("top10SuccessfulDeployments") {
        @Override
        public Widget getWidget(final TaskArchive taskArchive) {
            return new Top10SuccessfulDeployments(taskArchive);
        }
    },
    TOP10RETRIEDDEPLOYMENTS("top10RetriedDeployments") {
        @Override
        public Widget getWidget(final TaskArchive taskArchive) {
            return new Top10RetriedDeployments(taskArchive);
        }
    },
    TOP10LONGESTRUNNINGDEPLOYMENTS("top10LongestRunningDeployments") {
        @Override
        public Widget getWidget(final TaskArchive taskArchive) {
            return new Top10LongestRunningDeployments(taskArchive);
        }
    };

    private String widgetName;

    WidgetRegistry(final String widgetName) {
        this.widgetName = widgetName;
    }

    public final String getWidgetType() {
        return widgetName;
    }

    public abstract Widget getWidget(final TaskArchive taskArchive);
}
