package com.xebialabs.deployit.core.rest.api

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.security.{PermissionDeniedException, Permissions}
import com.xebialabs.deployit.security.permission.Permission
import scala.jdk.CollectionConverters._

abstract class AbstractUserRestrictedResource extends AbstractSecuredResource {
  def isCurrentUser(username: String): Boolean =
    username.equals(Permissions.getAuthenticatedUserName)

  def isCurrentUserOrHasPermission(username: String, permission: Permission): Boolean = {
    isCurrentUser(username) || hasPermission(permission)
  }

  def checkCurrentUser(username: String): Unit = {
    if(!isCurrentUser(username)) {
      PermissionDeniedException.withMessage(s"You are not allowed to view users '$username' profile.")
    }
  }

  def checkCurrentUserOrPermissions(username: String, permissions: Permission*): Unit= {
    if(!isCurrentUser(username) && permissions.forall(!_.getPermissionHandler.hasPermission(null.asInstanceOf[String]))){
      PermissionDeniedException.forPermissions(permissions.toList.asJava, null)
    }
  }

  def checkCurrentUserOrPermission(username: String, permission: Permission) :Unit= {
    if(!isCurrentUser(username) && !hasPermission(permission)) {
      PermissionDeniedException.forPermission(permission, null.asInstanceOf[String])
    }
  }
}
