package com.xebialabs.deployit.core.service.status

import com.xebialabs.deployit.engine.api.dto.{ApplicationDeploymentPackage, ApplicationDeploymentPackageState, DeployedApplicationPackage}
import grizzled.slf4j.Logging
import org.springframework.jms.annotation.JmsListener
import org.springframework.jms.support.converter.MessageConverter
import org.springframework.stereotype.Component

import javax.jms.TextMessage

@Component
class DeploymentPackageStatusConsumer(
                                       jacksonJmsMessageConverter: MessageConverter,
                                       deploymentPackageStatusService: DeploymentPackageStatusService
                                     ) extends Logging {
  @JmsListener(
    destination = "#{@deploymentPackageStatusQueueNameResolver.getDeploymentPackageStatusQueueName()}",
    containerFactory = "xlJmsListenerContainerFactory"
  )
  def receiveTextMessage(message: TextMessage): Unit =
    jacksonJmsMessageConverter.fromMessage(message) match {
      case event: ApplicationDeploymentPackage =>
        deploymentPackageStatusService.send(event)
      case event: DeployedApplicationPackage =>
        deploymentPackageStatusService.send(event)
      case stateChange: ApplicationDeploymentPackageState =>
        deploymentPackageStatusService.send(stateChange)
      case _ =>
        logger.error(s"Received unknown ${message.getJMSMessageID} timestamp: ${message.getJMSTimestamp} [$message]")
    }
}
