package com.xebialabs.deployit.core.rest.websockets

import org.springframework.messaging.{Message, MessageChannel}
import org.springframework.messaging.simp.SimpMessageHeaderAccessor
import org.springframework.messaging.simp.stomp.{StompCommand, StompHeaderAccessor}
import org.springframework.messaging.support.{ChannelInterceptor, MessageHeaderAccessor}
import org.springframework.stereotype.Component

@Component
class UserInterceptor extends ChannelInterceptor {
  override def preSend(message: Message[_], channel: MessageChannel): Message[_] = {
    val stompHeaderAccessor = MessageHeaderAccessor.getAccessor(message, classOf[StompHeaderAccessor])
    val simpMessageHeaderAccessor = MessageHeaderAccessor.getAccessor(message, classOf[SimpMessageHeaderAccessor])

    if (StompCommand.CONNECT == stompHeaderAccessor.getCommand) {
      val principal = simpMessageHeaderAccessor.getUser
      stompHeaderAccessor.setUser(principal)
    }

    message
  }
}