/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.util.CiUtils;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.TopNByStateReportLine;
import java.util.Collection;
import org.joda.time.DateTime;

public abstract class Top10DeploymentsByState
extends DashboardWidgetBase {
    private static final String APPLICATION_NAME = "application";
    private static final String ENVIRONMENT = "environment";
    private static final String NUMBER_OF_DEPLOYMENTS_IN_A_STATE = "numOfDeployments";
    private static final String TOTAL_DEPLOYMENTS = "totalDeployments";
    private static final String PERCENTAGE = "percentage";
    private final DeploymentResult stateType;

    public Top10DeploymentsByState(TaskArchive taskArchive, DeploymentResult stateType) {
        super(taskArchive);
        this.stateType = stateType;
    }

    @Override
    public Report getReport(DateTime begin, DateTime end) {
        Collection searchResult = this.taskArchive.topNDeploymentsByState(begin, end, this.stateType, 10);
        return this.transformResult(searchResult);
    }

    private Report transformResult(Collection<TopNByStateReportLine> searchResult) {
        Report report = new Report();
        searchResult.forEach(sr -> {
            ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, (Object)sr.application());
            reportLine.addValue(ENVIRONMENT, (Object)CiUtils.getIdWithoutRoot((String)sr.environment()));
            reportLine.addValue(NUMBER_OF_DEPLOYMENTS_IN_A_STATE, (Object)String.valueOf(sr.numOfDeployTasksInAState()));
            reportLine.addValue(TOTAL_DEPLOYMENTS, (Object)String.valueOf(sr.totalDeployTasks()));
            reportLine.addValue(PERCENTAGE, (Object)Top10DeploymentsByState.getFormattedPercentage(sr.numOfDeployTasksInAState(), sr.totalDeployTasks()));
        });
        return report;
    }
}

