package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class MethodDescriptorJsonWriter implements MessageBodyWriter<MethodDescriptor> {

    @Override
    public boolean isWriteable(Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return MethodDescriptor.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final MethodDescriptor methodDescriptor, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final MethodDescriptor methodDescriptor, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(methodDescriptor).getBytes());
    }

    @VisibleForTesting
    String toJson(MethodDescriptor methodDescriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writeJson(methodDescriptor, writer);
        return stringWriter.toString();
    }

    static void writeJson(final MethodDescriptor methodDescriptor, final JsonWriter writer) {
        writer.object();
        writer.key("name").value(methodDescriptor.getName());
        writer.key("fqn").value(methodDescriptor.getFqn());
        writer.key("description").value(methodDescriptor.getDescription());
        writer.key("label").value(methodDescriptor.getLabel());

        writer.endObject();
    }
}
