package com.xebialabs.deployit.core.rest.sql

import grizzled.slf4j.Logging
import jakarta.ws.rs.core.{MediaType, Response}
import jakarta.ws.rs.ext.{ExceptionMapper, Provider}
import org.springframework.dao.DataIntegrityViolationException
import org.springframework.stereotype.Component

/**
 * Catch "all" exception handler that will prevent details of SQL structure to be shown in errors in the UI.
 * The message is very generic and not very helpful, could be improved for specific cases later.
 * @see DataIntegrityViolationException Springs wrapper for DB constraint violations.
 */
@Component
@Provider
class SqlExceptionMapper extends ExceptionMapper[DataIntegrityViolationException] with Logging {
  private val msg = "The system was not able to process this request due to incorrect data (e.g. value too long). Please see the server log for more details."

  override def toResponse(exception: DataIntegrityViolationException): Response = {
    logger.error("Failing user request due to database error.", exception)
    Response.status(Response.Status.BAD_REQUEST).entity(msg).`type`(MediaType.TEXT_PLAIN).build()
  }
}
