package com.xebialabs.deployit.core.rest.xml

import com.thoughtworks.xstream.converters.{MarshallingContext, UnmarshallingContext}
import com.thoughtworks.xstream.io.{HierarchicalStreamReader, HierarchicalStreamWriter}
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine
import com.xebialabs.xltype.serialization.util.DateUtil
import com.xebialabs.xltype.serialization.xstream.{AbstractTaskWithBlockConverter, XStreamProvider}

@XStreamProvider(readable = classOf[DeploymentTaskReportLine], tagName = "deploymentTaskReportLine")
class DeploymentTaskReportLineWriter extends AbstractTaskWithBlockConverter {
  override def marshal(source: Any, writer: HierarchicalStreamWriter, context: MarshallingContext): Unit = {
    val line = source.asInstanceOf[DeploymentTaskReportLine]
    writer.addAttribute("taskId", line.getTaskId)
    writer.addAttribute("startDate", DateUtil.toString(line.getStartDate))
    writer.addAttribute("completionDate", DateUtil.toString(line.getCompletionDate))
    writer.addAttribute("status", line.getStatus)
    writer.addAttribute("type", line.getTaskType)
    writer.addAttribute("originalType", line.getOriginalTaskType)
    writer.addAttribute("user", line.getUser)
    writer.addAttribute("environment", line.getEnvironment)
    writer.addAttribute("environmentId", line.getEnvironmentId)
    writer.addAttribute("environmentIdWithoutRoot", line.getEnvironmentIdWithoutRoot)
    writer.addAttribute("package", line.getDeploymentPackage)
    writer.addAttribute("rolledBack", line.getRolledBack.toString)
    writer.addAttribute("worker_name", line.getWorkerName)
    Option(line.getBlock).foreach(writePhaseContainer(writer, context, _))
  }

  override def unmarshal(reader: HierarchicalStreamReader, context: UnmarshallingContext): AnyRef =
    throw new UnsupportedOperationException(s"Core will not deserialize ${classOf[DeploymentTaskReportLine].getName}")

  override def canConvert(`type`: Class[_]): Boolean = classOf[DeploymentTaskReportLine].isAssignableFrom(`type`)
}
