package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util

import ai.digital.deploy.sql.model.{DefinedPlaceholderReference, DictionaryWithValueView}
import com.xebialabs.xltype.serialization.json.JsonWriter
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import jakarta.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class DictionaryWithValueViewJsonWriter extends MessageBodyWriter[util.Collection[DictionaryWithValueView]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[DictionaryWithValueView].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(viewList: util.Collection[DictionaryWithValueView], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(viewList: util.Collection[DictionaryWithValueView], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val streamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(viewList, new JsonWriter(streamWriter))
    streamWriter.flush()
  }

  private def writeReference(key: String, reference: DefinedPlaceholderReference, writer: JsonWriter): Unit = {
    writer.key(key)
    writer.`object`()
    writer.key("id").value(reference.getId)
    writer.key("ciType").value(reference.getCiType)
    writer.endObject()
  }

  private def writeJson(viewList: util.Collection[DictionaryWithValueView], writer: JsonWriter): Unit = {
    writer.array
    viewList.forEach(view => {
      writer.`object`()
      writer.key("value").value(view.getValue)
      writer.key("isEncrypted").value(view.isEncrypted)

      writeReference("dictionary", view.getDictionary, writer)

      writer.endObject()
    })
    writer.endArray
  }

}
