package com.xebialabs.deployit.core.service

import ai.digital.deploy.webhook.WebhookServer

import scala.jdk.CollectionConverters._

trait ApplicationAndEnvironmentFilter {
  protected def matchAppEnvToDeploymentRegexp(webhookServer: WebhookServer, applicationId: String, environmentId: String): Boolean = {
    Option(webhookServer.deploymentRegexpSet).exists { deploymentRegexpSet =>
      deploymentRegexpSet.asScala.exists { deploymentRegexp =>
        applicationId.matches(deploymentRegexp.application) && environmentId.matches(deploymentRegexp.environment)
      }
    }
  }
}
