/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DeploymentsBreakdownInDateRangeReport {
    private RepositoryService repositoryService;
    private TaskRegistry taskRegistry;

    public DeploymentsBreakdownInDateRangeReport(RepositoryService repositoryService, TaskRegistry taskRegistry) {
        this.repositoryService = repositoryService;
        this.taskRegistry = taskRegistry;
    }

    public Report report(List<String> applicationIds, Date begin, Date end) {
        Report report = new Report();
        HashMap deploymentsBreakdownMap = Maps.newHashMap();
        ArrayList values = Lists.newArrayList();
        SearchParameters searchParams = SearchParameterFactory.createSearchParam(Deployment.class.getName(), false, 0L, -1L, values, "", "");
        List deployments = this.repositoryService.listEntities(searchParams);
        for (ConfigurationItemEntity deployment : deployments) {
            ConfigurationItemEntity deploymentPackage;
            String fullApplicationId;
            String applicationId;
            Task task;
            if (deployment.getCreatingTaskId() == null || !(task = this.taskRegistry.getTask(deployment.getCreatingTaskId())).getStartDate().after(begin.getCalendar()) || !task.getCompletionDate().before(end.getCalendar()) || !applicationIds.contains(applicationId = (fullApplicationId = (deploymentPackage = (ConfigurationItemEntity)this.repositoryService.read((String)deployment.getValue("source"))).getValue("application").toString()).substring(fullApplicationId.indexOf("/") + 1))) continue;
            if (deploymentsBreakdownMap.containsKey(applicationId)) {
                ((AtomicInteger)deploymentsBreakdownMap.get(applicationId)).incrementAndGet();
                continue;
            }
            deploymentsBreakdownMap.put(applicationId, new AtomicInteger(1));
        }
        for (String applicationId : applicationIds) {
            if (deploymentsBreakdownMap.containsKey(applicationId)) continue;
            deploymentsBreakdownMap.put(applicationId, new AtomicInteger(0));
        }
        if (!deploymentsBreakdownMap.isEmpty()) {
            report = this.generateReportFromMap(deploymentsBreakdownMap);
        }
        return report;
    }

    private Report generateReportFromMap(Map<String, AtomicInteger> deploymentsBreakdownMap) {
        Report report = new Report();
        for (Map.Entry<String, AtomicInteger> entry : deploymentsBreakdownMap.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("application", (Object)entry.getKey());
            reportLine.addValue("noofdeployments", (Object)entry.getValue().toString());
        }
        return report;
    }
}

