/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.Mappings;
import com.xebialabs.deployit.core.api.dto.Archetype;
import com.xebialabs.deployit.core.api.dto.Artifact;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyType;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfos;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DtoConverter {
    private RepositoryService repositoryService;
    private PojoConverter pojoConverter;
    private ConfigurationItemTypeDescriptorRepository descriptorRepository;

    @Autowired
    public DtoConverter(RepositoryService repositoryService, PojoConverter pojoConverter, ConfigurationItemTypeDescriptorRepository descriptorRepository) {
        this.repositoryService = repositoryService;
        this.pojoConverter = pojoConverter;
        this.descriptorRepository = descriptorRepository;
    }

    public RepositoryObject toDto(RepositoryObjectEntity entity) {
        Artifact dto;
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)entity.getId());
        if (entity instanceof ArtifactEntity) {
            dto = new Artifact();
        } else if (entity instanceof ConfigurationItemEntity) {
            dto = new ConfigurationItem();
        } else if (entity instanceof ArchetypeEntity) {
            dto = new Archetype();
        } else {
            throw new IllegalArgumentException("entity is not of class " + ConfigurationItemEntity.class.getName() + " or class " + ArchetypeEntity.class.getName());
        }
        ArchetypeEntity archetype = entity.getConfigurationItemArchetype();
        if (archetype != null) {
            dto.setArchetypeId(archetype.getId());
        }
        dto.setId(entity.getId());
        dto.setConfigurationItemTypeName(entity.getConfigurationItemTypeName());
        dto.setLastModified(entity.getLastModified());
        dto.setOverrideLastModified(null);
        dto.setCreatingTaskId(entity.getCreatingTaskId());
        this.copyValuesToDto(entity, (RepositoryObject)dto);
        return dto;
    }

    private void copyValuesToDto(RepositoryObjectEntity entity, RepositoryObject dto) {
        HashMap map = Maps.newHashMap();
        ConfigurationItemDescriptor descriptor = this.descriptorRepository.getDescriptorByType(entity.getConfigurationItemTypeName());
        for (Map.Entry entry : entity.getValues().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor((String)entry.getKey());
            if (propertyDescriptor != null && propertyDescriptor.isPassword()) {
                value = "********";
            }
            map.put(key, value);
        }
        dto.setValues((Map)map);
    }

    public RepositoryObjectEntity fromDto(RepositoryObject dto) {
        Preconditions.checkNotNull((Object)dto);
        Preconditions.checkNotNull((Object)dto.getId());
        RepositoryObjectEntity entity = this.createEntity(dto);
        entity.setId(dto.getId());
        entity.setLastModified(null);
        entity.setOverrideLastModified(dto.getOverrideLastModified());
        entity.setCreatingTaskId(null);
        this.copyValues(dto, entity);
        if (dto instanceof Artifact) {
            entity.addValue("location", (Object)("jcr://" + entity.getId()));
        }
        return entity;
    }

    private void copyValues(RepositoryObject from, RepositoryObjectEntity to) {
        for (String fromKey : from.getValues().keySet()) {
            to.addValue(fromKey, from.getValues().get(fromKey));
        }
    }

    private RepositoryObjectEntity createEntity(RepositoryObject dto) {
        ConfigurationItemEntity entity;
        if (dto instanceof Artifact) {
            entity = this.createObjectWithDefaults(dto.getConfigurationItemTypeName());
        } else if (dto instanceof ConfigurationItem) {
            if (StringUtils.isNotBlank((String)dto.getArchetypeId())) {
                ArchetypeEntity archetype = (ArchetypeEntity)this.repositoryService.read(dto.getArchetypeId());
                if (StringUtils.isNotBlank((String)dto.getConfigurationItemTypeName())) {
                    entity = new ConfigurationItemEntity(dto.getConfigurationItemTypeName());
                    entity.setArchetype(archetype);
                } else {
                    entity = new ConfigurationItemEntity(archetype);
                }
            } else {
                entity = this.createObjectWithDefaults(dto.getConfigurationItemTypeName());
            }
        } else if (StringUtils.isNotBlank((String)dto.getArchetypeId())) {
            ArchetypeEntity archetype = (ArchetypeEntity)this.repositoryService.read(dto.getArchetypeId());
            if (StringUtils.isNotBlank((String)dto.getConfigurationItemTypeName())) {
                entity = new ArchetypeEntity(dto.getConfigurationItemTypeName());
                entity.setArchetype(archetype);
            } else {
                entity = new ArchetypeEntity(archetype);
            }
        } else {
            ConfigurationItemEntity defaults = this.createObjectWithDefaults(dto.getConfigurationItemTypeName());
            entity = new ArchetypeEntity(dto.getConfigurationItemTypeName());
            entity.setValues(defaults.getValues());
        }
        return entity;
    }

    private ConfigurationItemEntity createObjectWithDefaults(String ciType) {
        Object ciPojo = this.descriptorRepository.getDescriptorByType(ciType).newInstance();
        return this.pojoConverter.toEntity(ciPojo);
    }

    public ArtifactEntity fromDto(ArtifactAndData dto) {
        Preconditions.checkNotNull((Object)dto);
        Preconditions.checkNotNull((Object)dto.getArtifact());
        Preconditions.checkNotNull((Object)dto.getArtifact().getId());
        Preconditions.checkNotNull((Object)dto.getData());
        ArtifactEntity entity = (ArtifactEntity)this.fromDto((RepositoryObject)dto.getArtifact());
        entity.setData((InputStream)new ByteArrayInputStream(dto.getData()));
        entity.addValue("location", (Object)("jcr://" + entity.getId()));
        return entity;
    }

    public RepositoryObjects toDto(Collection<? extends RepositoryObjectEntity> entities) {
        Preconditions.checkNotNull(entities);
        RepositoryObjects objects = new RepositoryObjects();
        for (RepositoryObjectEntity repositoryObjectEntity : entities) {
            objects.add(this.toDto(repositoryObjectEntity));
        }
        return objects;
    }

    public RepositoryObjects toDto(Mappings mappings) {
        Preconditions.checkNotNull((Object)mappings);
        RepositoryObjects objects = new RepositoryObjects();
        for (ConfigurationItemEntity validMappingEntity : mappings.getValidMappings()) {
            RepositoryObject validMapping = this.toDto((RepositoryObjectEntity)validMappingEntity);
            objects.add(validMapping);
        }
        for (ConfigurationItemEntity invalidMappingEntity : mappings.getInvalidMappings()) {
            RepositoryObject invalidMapping = this.toDto((RepositoryObjectEntity)invalidMappingEntity);
            ArrayList<Message> validations = new ArrayList<Message>();
            validations.add(new Message("source", "A valid source for this mapping could not be found to upgrade."));
            invalidMapping.setValidations(validations);
            objects.add(invalidMapping);
        }
        return objects;
    }

    public <T extends RepositoryObjectEntity> Collection<T> fromDto(RepositoryObjects objects) {
        Preconditions.checkNotNull((Object)objects);
        ArrayList entities = Lists.newArrayList();
        for (RepositoryObject each : objects.getObjects()) {
            entities.add(this.fromDto(each));
        }
        return entities;
    }

    public ConfigurationItemDescriptorDto toDto(ConfigurationItemDescriptor descriptor) {
        ConfigurationItemPropertyDescriptor[] originalPropertyDescriptors;
        Preconditions.checkNotNull((Object)descriptor);
        ConfigurationItemDescriptorDto dto = new ConfigurationItemDescriptorDto();
        dto.setType(descriptor.getType());
        dto.setSimpleName(descriptor.getSimpleName());
        dto.setInterfaces(descriptor.getInterfaces());
        dto.setSuperClasses(descriptor.getSuperClasses());
        dto.setMappingSourceType(descriptor.getMappingSourceType());
        dto.setMappingTargetType(descriptor.getMappingTargetType());
        dto.setDescription(descriptor.getDescription());
        dto.setPlaceholderFormatName(descriptor.getPlaceholderFormatName());
        dto.setPlaceholdersName(descriptor.getPlaceholdersName());
        for (ConfigurationItemPropertyDescriptor propertyDescriptor : originalPropertyDescriptors = descriptor.getPropertyDescriptors()) {
            dto.addPropertyDescriptor(this.toDto(propertyDescriptor));
        }
        return dto;
    }

    public ConfigurationItemPropertyDescriptorDto toDto(ConfigurationItemPropertyDescriptor propertyDescriptor) {
        Preconditions.checkNotNull((Object)propertyDescriptor);
        ConfigurationItemPropertyDescriptorDto dto = new ConfigurationItemPropertyDescriptorDto();
        dto.setName(propertyDescriptor.getName());
        dto.setLabel(propertyDescriptor.getLabel());
        dto.setType(ConfigurationItemPropertyType.valueOf((String)propertyDescriptor.getType().toString()));
        dto.setEnumValues(propertyDescriptor.getEnumValues());
        dto.setCollectionMemberClassname(propertyDescriptor.getCollectionMemberClassname());
        dto.setPropertyClassname(propertyDescriptor.getPropertyClassname());
        dto.setRequired(propertyDescriptor.isRequired());
        dto.setEditable(propertyDescriptor.isEditable());
        dto.setPassword(propertyDescriptor.isPassword());
        dto.setIdentifying(propertyDescriptor.isIdentifying());
        dto.setDiscoveryParam(propertyDescriptor.isDiscoveryParam());
        dto.setDiscoveryRequired(propertyDescriptor.isDiscoveryRequired());
        dto.setCategory(propertyDescriptor.getCategory());
        dto.setDefaultValue(propertyDescriptor.getDefaultValue());
        dto.setDescription(propertyDescriptor.getDescription());
        dto.setAsContainment(propertyDescriptor.asContainment());
        ConfigurationItemPropertyDescriptor[] originalPropertyDescriptors = propertyDescriptor.getListObjectPropertyDescriptors();
        if (originalPropertyDescriptors != null) {
            for (ConfigurationItemPropertyDescriptor listObjectPropertyDescriptor : originalPropertyDescriptors) {
                dto.addPropertyDescriptor(this.toDto(listObjectPropertyDescriptor));
            }
        }
        return dto;
    }

    public TaskInfo toDto(String id, Task task) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)task);
        TaskInfo ti = new TaskInfo();
        ti.setId(id);
        ti.setLabel(task.getLabel());
        ti.setState(task.getState().name());
        ti.setStartDate(task.getStartDate());
        ti.setCompletionDate(task.getCompletionDate());
        ti.setNrOfSteps(task.getNrOfSteps());
        ti.setCurrentStepNr(task.getCurrentStepNr());
        if (task.getOwner() != null) {
            ti.setUser(task.getOwner());
        }
        return ti;
    }

    public StepInfo toDto(int stepNr, TaskStep step) {
        Preconditions.checkNotNull((Object)step);
        StepInfo si = new StepInfo();
        si.setNr(stepNr);
        si.setDescription(step.getDescription());
        si.setState(step.getState().name());
        si.setStartDate(step.getStartDate());
        si.setCompletionDate(step.getCompletionDate());
        si.setLog(step.getLog());
        return si;
    }

    public Steps toDto(Task deploymentTask) {
        Steps steps = new Steps();
        List stepList = deploymentTask.getSteps();
        int stepNr = 1;
        for (TaskStep taskStep : stepList) {
            steps.add(this.toDto(stepNr++, taskStep));
        }
        return steps;
    }

    public TaskInfos toTaskInfos(List<Task> tasks) {
        TaskInfos taskInfos = new TaskInfos();
        for (Task eachTask : tasks) {
            taskInfos.add(this.toDto(eachTask.getId(), eachTask));
        }
        return taskInfos;
    }

    public RepositoryObject toDto(RepositoryObjectEntity entity, List<ValidationMessage> messages) {
        RepositoryObject repositoryObject = this.toDto(entity);
        repositoryObject.setValidations(this.toDto(messages));
        return repositoryObject;
    }

    public List<Message> toDto(List<ValidationMessage> messages) {
        ArrayList list = Lists.newArrayList();
        for (ValidationMessage validationMessage : messages) {
            list.add(new Message(validationMessage.getFieldName(), validationMessage.getMessage()));
        }
        return list;
    }
}

