/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;

public class DeploymentTrendsWidget
extends DashboardWidgetBase {
    private DeploymentTrendsWidget(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentTrendsWidget(taskArchive);
    }

    @Override
    public final Report getReport(Date begin, Date end) {
        Map<String, TaskStateData> taskStates = this.groupTasksByStateAndDate(begin, end);
        return this.generateReportData(taskStates);
    }

    private Report generateReportData(Map<String, TaskStateData> taskStates) {
        Report report = new Report();
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        for (String month : taskStates.keySet()) {
            TaskStateData stateData = taskStates.get(month);
            Report.ReportLine line = report.addLine();
            line.addValue("month", (Object)month);
            line.addValue("noOfSuccessfulDeployments", (Object)stateData.getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfAbortedDeployments", (Object)stateData.getNoOfAbortedDeployments().toString());
            line.addValue("noOfFailedDeployments", (Object)stateData.getNoOfFailedDeployments().toString());
            long totalTasks = stateData.getTotalTasks();
            line.addValue("percentageSuccessfulDeployments", (Object)decimalFormat.format(this.getPercentage(stateData.getNoOfSuccessfulDeployments().get(), totalTasks)));
        }
        return report;
    }

    private Map<String, TaskStateData> groupTasksByStateAndDate(Date begin, Date end) {
        final Map<String, TaskStateData> stateDataMap = this.initializeMap(begin, end, new Function<String, TaskStateData>(){

            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        });
        ArchivedTaskSearchParameters params = new ArchivedTaskSearchParameters().createdBetween(begin.getCalendar(), end.getCalendar());
        this.taskArchive.searchTasksWithoutLoadingSteps(params, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo task) {
                String month = DeploymentTrendsWidget.this.monthFormat.format(task.getCompletionDate().getTime());
                ((TaskStateData)stateDataMap.get(month)).addTask(task);
            }
        });
        return stateDataMap;
    }
}

