/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;

public class DeploymentTrendsWidget
extends DashboardWidgetBase {
    private DeploymentTrendsWidget(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentTrendsWidget(taskArchive);
    }

    @Override
    public final Report getReport(Date date, Date date2) {
        Map<String, TaskStateData> map = this.groupTasksByStateAndDate(date, date2);
        return this.generateReportData(map);
    }

    private Report generateReportData(Map<String, TaskStateData> map) {
        Report report = new Report();
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        for (String string : map.keySet()) {
            TaskStateData taskStateData = map.get(string);
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("month", (Object)string);
            reportLine.addValue("noOfSuccessfulDeployments", (Object)taskStateData.getNoOfSuccessfulDeployments().toString());
            reportLine.addValue("noOfAbortedDeployments", (Object)taskStateData.getNoOfAbortedDeployments().toString());
            reportLine.addValue("noOfFailedDeployments", (Object)taskStateData.getNoOfFailedDeployments().toString());
            long l = taskStateData.getTotalTasks();
            reportLine.addValue("percentageSuccessfulDeployments", (Object)decimalFormat.format(this.getPercentage(taskStateData.getNoOfSuccessfulDeployments().get(), l)));
        }
        return report;
    }

    private Map<String, TaskStateData> groupTasksByStateAndDate(Date date, Date date2) {
        final Map<String, TaskStateData> map = this.initializeMap(date, date2, new Function<String, TaskStateData>(){

            public TaskStateData apply(String string) {
                return new TaskStateData();
            }
        });
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters().createdBetween(date.getCalendar(), date2.getCalendar());
        this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                String string = DeploymentTrendsWidget.this.monthFormat.format(deploymentTaskInfo.getCompletionDate().getTime());
                TaskStateData taskStateData = (TaskStateData)map.get(string);
                if (taskStateData != null) {
                    taskStateData.addTask(deploymentTaskInfo);
                }
            }
        });
        return map;
    }
}

