/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.jcr.grouping.Count;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class Top5DeploymentsByState
extends DashboardWidgetBase {
    static final String FAILURE_COUNT = "failureCount";
    static final String STATE = "state";
    static final String COUNT = "count";
    static final String APPLICATION_NAME = "applicationName";
    static final String ENVIRONMENT = "environment";

    abstract boolean accept(Map<String, Object> var1);

    @Override
    public Report getReport(Date date, Date date2) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.createdBetween(date.getCalendar(), date2.getCalendar());
        Collection collection = this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{APPLICATION_NAME, ENVIRONMENT, STATE, FAILURE_COUNT}), new Function[]{new Count(COUNT)}));
        return this.getTop5(collection);
    }

    private Report getTop5(Collection<Map<String, Object>> collection) {
        Map<String, Integer> map = this.calculateTotalsPerApplicationPerEnvironment(collection);
        List<Map<String, Object>> list = this.filterByState(collection);
        Collections.sort(list, new Top5Comparator(map));
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        Report report = new Report();
        for (Map<String, Object> map2 : list.subList(0, Math.min(list.size(), 5))) {
            Report.ReportLine reportLine = report.addLine();
            String string = (String)map2.get(APPLICATION_NAME) + "-" + (String)map2.get(ENVIRONMENT);
            reportLine.addValue(APPLICATION_NAME, (Object)((String)map2.get(APPLICATION_NAME)));
            reportLine.addValue("environmentName", (Object)((String)map2.get(ENVIRONMENT)));
            reportLine.addValue("numOfDeployments", (Object)map2.get(COUNT).toString());
            reportLine.addValue("totalDeployments", (Object)map.get(string).toString());
            reportLine.addValue("percentage", (Object)decimalFormat.format(this.getPercentage(((Integer)map2.get(COUNT)).intValue(), map.get(string).intValue())));
        }
        return report;
    }

    private Map<String, Integer> calculateTotalsPerApplicationPerEnvironment(Collection<Map<String, Object>> collection) {
        HashMap hashMap = Maps.newHashMap();
        for (Map<String, Object> map : collection) {
            String string = (String)map.get(APPLICATION_NAME) + "-" + (String)map.get(ENVIRONMENT);
            Integer n = (Integer)hashMap.get(string);
            n = n == null ? (Integer)map.get(COUNT) : Integer.valueOf(n + (Integer)map.get(COUNT));
            hashMap.put(string, n);
        }
        return hashMap;
    }

    private List<Map<String, Object>> filterByState(Collection<Map<String, Object>> collection) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map<String, Object> map : collection) {
            if (!this.accept(map)) continue;
            arrayList.add(map);
        }
        return arrayList;
    }

    private static final class Top5Comparator
    implements Comparator<Map<String, Object>> {
        private final Map<String, Integer> totalsMap;

        private Top5Comparator(Map<String, Integer> map) {
            this.totalsMap = map;
        }

        @Override
        public int compare(Map<String, Object> map, Map<String, Object> map2) {
            int n = ((Integer)map.get(Top5DeploymentsByState.COUNT)).compareTo((Integer)map2.get(Top5DeploymentsByState.COUNT));
            if (n == 0) {
                Integer n2 = this.totalsMap.get((String)map.get(Top5DeploymentsByState.APPLICATION_NAME) + "-" + (String)map.get(Top5DeploymentsByState.ENVIRONMENT));
                Integer n3 = this.totalsMap.get((String)map2.get(Top5DeploymentsByState.APPLICATION_NAME) + "-" + (String)map2.get(Top5DeploymentsByState.ENVIRONMENT));
                n = -n2.compareTo(n3);
            }
            return -n;
        }
    }
}

