/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DeploymentTrendsWidget
extends DashboardWidgetBase {
    public DeploymentTrendsWidget(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public final Report getReport(DateTime begin, DateTime end) {
        Map<String, TaskStateData> taskStates = this.groupTasksByStateAndDate(begin, end);
        return DeploymentTrendsWidget.generateReportData(taskStates);
    }

    private static Report generateReportData(Map<String, TaskStateData> taskStates) {
        Report report = new Report();
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        for (String month : taskStates.keySet()) {
            TaskStateData stateData = taskStates.get(month);
            Report.ReportLine line = report.addLine();
            line.addValue("month", (Object)month);
            line.addValue("noOfSuccessfulDeployments", (Object)stateData.getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfAbortedDeployments", (Object)stateData.getNoOfAbortedDeployments().toString());
            line.addValue("noOfFailedDeployments", (Object)stateData.getNoOfFailedDeployments().toString());
            line.addValue("noOfRollbacks", (Object)stateData.getNoOfRollbacks().toString());
            long totalTasks = stateData.getTotalTasks();
            line.addValue("percentageSuccessfulDeployments", (Object)decimalFormat.format(DeploymentTrendsWidget.getPercentage(stateData.getNoOfSuccessfulDeployments().get(), totalTasks)));
        }
        return report;
    }

    private Map<String, TaskStateData> groupTasksByStateAndDate(DateTime begin, DateTime end) {
        final Map<String, TaskStateData> stateDataMap = this.initializeMap(begin, end, new Function<String, TaskStateData>(){

            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        });
        ArchivedTaskSearchParameters params = this.getSearchParameters().createdBetween(begin, end);
        this.taskArchive.searchTasksWithoutLoadingSteps(params, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(ArchivedTask task) {
                String month = DeploymentTrendsWidget.this.monthFormat.print((ReadableInstant)task.getCompletionDate());
                TaskStateData dataPerMonth = (TaskStateData)stateDataMap.get(month);
                if (dataPerMonth != null) {
                    dataPerMonth.addTask((TaskState)task);
                }
            }
        });
        return stateDataMap;
    }
}

