/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.xml.ConfigurationItemWriter;
import com.xebialabs.deployit.engine.xml.XStreamProvider;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.EncryptedDictionary;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.overthere.OverthereFile;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class ConfigurationItemReaderWriter
extends ConfigurationItemWriter {
    private final RepositoryService repository;
    private final StringValueConverter converter;
    static final ThreadLocal<Map<String, ConfigurationItem>> DESERIALIZATION_CONTEXT = new ThreadLocal<Map<String, ConfigurationItem>>(){

        @Override
        protected Map<String, ConfigurationItem> initialValue() {
            return Maps.newHashMap();
        }
    };
    static final ThreadLocal<List<Reference>> DESERIALIZATION_REFERENCES = new ThreadLocal<List<Reference>>(){

        @Override
        protected List<Reference> initialValue() {
            return Lists.newArrayList();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationItemReaderWriter.class);

    @Autowired
    public ConfigurationItemReaderWriter(RepositoryService repository) {
        this.repository = repository;
        this.converter = new StringValueConverter(this.passwordEncrypter);
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        if (propertyDescriptor.isPassword()) {
            propertyDescriptor.set(configurationItem, (Object)this.passwordEncrypter.ensureDecrypted(reader.getValue()));
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        AbstractCollection strings;
        AbstractCollection abstractCollection = strings = propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING ? Sets.newHashSet() : Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            strings.add(this.converter.convert(reader.getValue()));
            reader.moveUp();
        }
        SetOfStringView view = propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING ? new SetOfStringView((Set)((Object)strings)) : new ListOfStringView((List)((Object)strings));
        propertyDescriptor.set(configurationItem, (Object)view);
    }

    protected void readMapStringStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        HashMap map = Maps.newHashMap();
        boolean encrypt = configurationItem.getType().equals((Object)Type.valueOf(EncryptedDictionary.class));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getAttribute("key"), this.converter.convert(reader.getValue(), encrypt));
            reader.moveUp();
        }
        propertyDescriptor.set(configurationItem, (Object)new MapStringStringView((Map)map));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigurationItem ci = (ConfigurationItem)super.unmarshal(reader, context);
        if (ci instanceof DerivedArtifact && WorkdirHolder.get() != null) {
            logger.trace("Setting DerivedFile on {}", (Object)ci.getId());
            ((DerivedArtifact)ci).setFile((OverthereFile)DerivedArtifactFile.create((DerivedArtifact)((DerivedArtifact)ci)));
        }
        DESERIALIZATION_CONTEXT.get().put(ci.getId(), ci);
        return ci;
    }

    protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        String id = reader.getAttribute("ref");
        DESERIALIZATION_REFERENCES.get().add(new ConfigurationItemReference(id, configurationItem, propertyDescriptor, this.repository));
    }

    protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        AbstractCollection cis = null;
        cis = propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            cis.add(reader.getAttribute("ref"));
            reader.moveUp();
        }
        DESERIALIZATION_REFERENCES.get().add(new ConfigurationItemsReference(cis, configurationItem, propertyDescriptor, this.repository));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void postProcess() {
        try {
            for (Reference reference : DESERIALIZATION_REFERENCES.get()) {
                reference.resolve();
            }
        }
        finally {
            ConfigurationItemReaderWriter.clear();
        }
    }

    public static void clear() {
        DESERIALIZATION_REFERENCES.remove();
        DESERIALIZATION_CONTEXT.remove();
    }

    private static class ConfigurationItemsReference
    implements Reference {
        private Collection<String> ids;
        private ConfigurationItem owner;
        private PropertyDescriptor property;
        private RepositoryService repository;

        private ConfigurationItemsReference(Collection<String> ids, ConfigurationItem owner, PropertyDescriptor property, RepositoryService repository) {
            this.ids = ids;
            this.owner = owner;
            this.property = property;
            this.repository = repository;
        }

        @Override
        public void resolve() {
            AbstractCollection cis = null;
            cis = this.property.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
            for (String id : this.ids) {
                if (DESERIALIZATION_CONTEXT.get().containsKey(id)) {
                    cis.add(DESERIALIZATION_CONTEXT.get().get(id));
                    continue;
                }
                cis.add(this.repository.read(id, WorkdirHolder.get()));
            }
            this.property.set(this.owner, (Object)cis);
        }
    }

    private static class ConfigurationItemReference
    implements Reference {
        private String id;
        private ConfigurationItem owner;
        private PropertyDescriptor property;
        private RepositoryService repository;

        private ConfigurationItemReference(String id, ConfigurationItem owner, PropertyDescriptor property, RepositoryService repository) {
            this.id = id;
            this.owner = owner;
            this.property = property;
            this.repository = repository;
        }

        @Override
        public void resolve() {
            ConfigurationItem ci = null;
            ci = DESERIALIZATION_CONTEXT.get().containsKey(this.id) ? DESERIALIZATION_CONTEXT.get().get(this.id) : this.repository.read(this.id, WorkdirHolder.get());
            this.property.set(this.owner, (Object)ci);
        }
    }

    static interface Reference {
        public void resolve();
    }
}

