/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.AbstractTaskResource;
import com.xebialabs.deployit.core.rest.api.StepBlockStateView;
import com.xebialabs.deployit.core.rest.api.support.TaskPermissionFilter;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Controller;

@Controller
public class TaskBlockResource
extends AbstractTaskResource
implements TaskBlockService {
    private Function<ArchivedTask, TaskWithBlock> castToTaskWithBlock = input -> input;

    public List<TaskWithBlock> getMyCurrentTasks() {
        String principal = Permissions.getAuthenticatedUserName();
        return this.engine.getAllIncompleteTasks().stream().filter(input -> input.getOwner().equals(principal)).map(input1 -> input1).collect(Collectors.toList());
    }

    public List<TaskWithBlock> getAllCurrentTasks() {
        List tasks = this.engine.getAllIncompleteTasks();
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            logger.debug("getAllCurrentTasks returning full list as ADMIN");
            return new ArrayList<TaskWithBlock>(tasks);
        }
        return tasks.stream().filter(new TaskPermissionFilter()).collect(Collectors.toList());
    }

    public TaskWithBlock getTask(String taskId) {
        return (TaskWithBlock)this.calledByOwner(this.liveOrArchivedTask(taskId, false));
    }

    public BlockState getBlock(String taskId, String blockId) {
        TaskWithBlock taskWithBlock = (TaskWithBlock)this.calledByOwner(this.liveOrArchivedTask(taskId, false));
        return (BlockState)((Block)taskWithBlock.getBlock()).getBlock(BlockPath.apply((String)blockId).tail()).getOrElse(null);
    }

    public StepBlockState getSteps(String taskId, String blockId) {
        TaskWithBlock task = (TaskWithBlock)this.calledByOwner(this.liveOrArchivedTask(taskId, true));
        BlockState block = (BlockState)((Block)task.getBlock()).getBlock(BlockPath.apply((String)blockId).tail()).getOrElse(null);
        if (block instanceof StepBlockState) {
            return new StepBlockStateView((StepBlockState)block);
        }
        throw new DeployitException("Block is a composite block so it has no steps");
    }

    public TaskWithBlock skip(String taskId, List<String> stepPaths) {
        return this.skip(taskId, stepPaths, true);
    }

    public TaskWithBlock unskip(String taskId, List<String> stepPaths) {
        return this.skip(taskId, stepPaths, false);
    }

    public StepBlockState addPause(String taskId, String stepPath) {
        Task task = this.engine.retrieve(taskId);
        BlockState block = (BlockState)task.getBlock(BlockPath.apply((String)stepPath).init()).getOrElse(null);
        if (block instanceof StepBlock) {
            this.pause(taskId, stepPath);
            return new StepBlockStateView((StepBlockState)((StepBlock)block));
        }
        throw new DeployitException("Block is a composite block so it has no steps to skip");
    }

    public TaskWithBlock assign(String taskId, String owner) {
        return this.doAssign(taskId, owner);
    }

    public TaskWithBlock takeover(String taskId, String owner) {
        return this.doTakeover(taskId, owner);
    }

    public List<TaskWithBlock> query(LocalDate begin, LocalDate end) {
        return this.search(this.toSearchParameters(begin, end), false).stream().map(this.castToTaskWithBlock).collect(Collectors.toList());
    }

    public List<TaskWithBlock> export(LocalDate begin, LocalDate end) {
        return this.search(this.toSearchParameters(begin, end), true).stream().map(this.castToTaskWithBlock).collect(Collectors.toList());
    }

    protected Task skip(String taskId, List<String> stepPaths, boolean skip) {
        Task task = this.engine.retrieve(taskId);
        List paths = stepPaths.stream().map(BlockPath::apply).collect(Collectors.toList());
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_SKIPSTEP, task);
        if (skip) {
            this.engine.skipStepPaths(taskId, paths);
        } else {
            this.engine.unskipStepPaths(taskId, paths);
        }
        return task;
    }

    protected void pause(String taskId, String stepPath) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can add pause to the task.");
        }
        this.engine.addPauseStep(taskId, BlockPath.apply((String)stepPath));
    }

    public StepState getStep(String taskId, String stepPath, DateTime ifModifiedSince) {
        TaskWithBlock taskWithBlock = (TaskWithBlock)this.calledByOwner(this.liveOrArchivedTask(taskId, false));
        StepState step = ((Block)taskWithBlock.getBlock()).getStep(BlockPath.apply((String)stepPath).tail());
        if (this.hasBeenModifiedSince(step, ifModifiedSince)) {
            return step;
        }
        throw new AbstractTaskResource.NotModifiedException();
    }
}

