/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.TaskArchive;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractPagingResource
extends AbstractSecuredResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractPagingResource.class);
    @Context
    private HttpResponse response;
    @Autowired
    private XldConfig config;
    @Autowired
    protected TaskArchive taskArchive;

    protected Paging getLimitedPaging(Paging input) {
        if (input.getResultsPerPage() <= 0 || input.getResultsPerPage() > this.config.restApi().maxPageSize()) {
            return new Paging(input.getPage(), this.config.restApi().maxPageSize());
        }
        return input;
    }

    protected void addPagingHeaderIfNeeded(Paging paging, Paging limited, ArchivedTaskSearchParameters searchParameters) {
        if (limited.getResultsPerPage() > 0) {
            int count = this.taskArchive.countTotalResults(searchParameters);
            if (paging.getResultsPerPage() <= 0 && count > limited.getResultsPerPage()) {
                log.warn("Limiting total number of results {} to maximum {}", (Object)count, (Object)limited.getResultsPerPage());
            }
            this.response.getOutputHeaders().putSingle((Object)"X-Total-Count", (Object)count);
        }
    }
}

