/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.engine.api.dto.ImportFromUrlParams;
import com.xebialabs.deployit.engine.spi.event.PackageImportedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.credentials.UsernamePasswordCredentials;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.service.importer.source.InputStreamSource;
import com.xebialabs.deployit.service.importer.source.UrlSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Tuple2;

@Controller
public class PackageResource
extends AbstractSecuredResource
implements PackageService {
    @Autowired
    private ImporterService importerService;
    @Autowired
    private RepositoryService repositoryService;

    public List<String> list() {
        return this.importerService.listPackages();
    }

    public ConfigurationItem importPackage(String file) {
        if (!this.importerService.getImportablePackageDirectory().exists()) {
            throw new ImporterException(String.format("Directory '%s' to import packages from does not exist", this.importerService.getImportablePackageDirectory().getAbsolutePath()), new Object[0]);
        }
        FileSource fileSource = new FileSource(new File(this.importerService.getImportablePackageDirectory(), file), false);
        return this.doImport((ImportSource)fileSource);
    }

    @Workdir(prefix="import")
    public ConfigurationItem fetch(String url) {
        try {
            UrlSource urlSource = new UrlSource(new URL(url), null, null);
            return this.doImport((ImportSource)urlSource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Workdir(prefix="import")
    public ConfigurationItem fetch(ImportFromUrlParams params) {
        try {
            Tuple2<String, String> credentials = this.getCredentials(params);
            UrlSource urlSource = new UrlSource(new URL(params.getUrl()), (String)credentials._1, (String)credentials._2);
            return this.doImport((ImportSource)urlSource);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Tuple2<String, String> getCredentials(ImportFromUrlParams params) throws IllegalArgumentException {
        if (!StringUtils.isBlank((String)params.getUser()) && !StringUtils.isBlank((String)params.getCredentialsId())) {
            throw new IllegalArgumentException("Can not use both style of credentials");
        }
        if (!StringUtils.isBlank((String)params.getUser())) {
            return new Tuple2((Object)params.getUser(), (Object)params.getPassword());
        }
        if (!StringUtils.isBlank((String)params.getCredentialsId())) {
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.repositoryService.read(params.getCredentialsId());
            return new Tuple2((Object)credentials.getUsername(), (Object)credentials.getPassword());
        }
        return new Tuple2((Object)"null", (Object)"null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Workdir(prefix="import")
    public ConfigurationItem upload(String file, FileUpload form) {
        try (FileInputStream packageStream = new FileInputStream(form.getFileData());){
            InputStreamSource byteArraySource = new InputStreamSource(file, (InputStream)packageStream);
            ConfigurationItem configurationItem = this.doImport((ImportSource)byteArraySource);
            return configurationItem;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error uploading file: %s", file));
        }
    }

    private ConfigurationItem doImport(ImportSource source) {
        String importedApplication = this.importerService.importPackage(source);
        ConfigurationItem read = this.repositoryService.read(importedApplication);
        EventBusHolder.publish((Object)new PackageImportedEvent(importedApplication));
        return read;
    }
}

