package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.settings.FeatureSettings;
import ai.digital.deploy.sql.model.settings.GeneralSettings;
import com.xebialabs.xlplatform.documentation.PublicApi;
import org.springframework.web.bind.annotation.RequestBody;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Path("/settings")
@Consumes({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
@PublicApi
public interface SettingsResource {

    @GET
    @Path("general")
    GeneralSettings getGeneralSettings();

    @POST
    @Path("general")
    GeneralSettings updateGeneralSettings(@RequestBody GeneralSettings generalSettings);

    @GET
    @Path("features")
    List<FeatureSettings> getFeatureSettings();

    @PUT
    @Path("features")
    List<FeatureSettings> saveFeatureSettings(@RequestBody List<FeatureSettings> features);
}
