package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.engine.api.dto.ApplicationDeploymentPackageState;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.xlplatform.documentation.PublicApi;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import java.util.List;

/**
 * Retrieves information about DeployedApplications
 *
 * A User must have READ permission on the environment and application to obtain the requested info.
 */
@Path("/application-status")
@PublicApi
@Produces({MediaType.APPLICATION_JSON})
public interface ApplicationStatusService {

    /**
     * Finds all DeployedApplications and DeploymentTasks whilst reducing them to show current status of any deployed or deploying application.
     * Optionally, part of the application name or start of application path/id (full path/id if exactPath flag is enabled) can be specified
     * to narrow the search result. A list of ApplicationDeploymentPackageState objects will be returned containing information about current
     * state of any deployed or deploying application package.
     *
     * @param deployedAppName (Optional) (part of the) deployed application name to query
     * @param path (Optional) (start of) the application path or id to query
     * @param exactPath (Optional) use full application path in queries (defaults to false)
     * @param order (Optional) which ordering to use when listing results
     * @return a list of {@see com.xebialabs.deployit.engine.api.dto.ApplicationDeploymentPackageState} objects corresponding application
     * deployment package states
     */
    @GET
    @Path("deployed-applications")
    List<ApplicationDeploymentPackageState> getDeployedApplications(
            @QueryParam("deployedAppName") String deployedAppName,
            @QueryParam("path") String path,
            @QueryParam("exactPath") boolean exactPath,
            @QueryParam("order") Ordering order,
            @QueryParam("folders") List<String> folders
    );

    /**
     * Finds all available Application folders path list
     *
     * @return a list of Strings containing all available folder names
     */
    @GET
    @Path("filterable-folders")
    List<String> getFilterableFolders();

}
