package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskSet;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xlplatform.documentation.PublicApi;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import java.util.stream.Stream;

@Path("/taskmonitor")
@Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@PublicApi
public interface TaskMonitorService {

    /**
     * Find all active Control Tasks, optionally filtered by parameters.
     *
     * @headers Content-Type application/json
     * @headers Cookie &lt;Cookie Value&gt;
     * @headers X-XSRF-TOKEN &lt;X-XSRF-TOKEN&gt;
     * @param begin filter by time interval beginning with date
     * @param end filter by time interval ending with date
     * @param states (Optional) filter task by task state
     * @param users (Optional) filter tasks belonging to users
     * @param taskName (Optional) filter by name of the task
     * @param taskId (Optional) filter task with exact taskId
     * @param fetchMode (Optional) toggle to fetch FULL task with blocks or just task SUMMARY
     * @param taskSet filter by taskSet - MY or ALL
     * @param paging (Optional) Which page and how many results per page to retrieve
     * @param order (Optional) Which ordering to use when listing results
     * @param workerName (Optional) filter only specified workers
     * @param targets filter by selected target CI
     * @return list of {@link TaskWithBlock}
     */
    @POST
    @Path("control")
    Stream<TaskWithBlock> getControlTasks(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @QueryParam("states") List<String> states,
            @QueryParam("users") List<String> users,
            @QueryParam("taskName") String taskName,
            @QueryParam("taskId") String taskId,
            @QueryParam("fetchMode") FetchMode fetchMode,
            @QueryParam("taskSet") TaskSet taskSet,
            @BeanParam Paging paging,
            @QueryParam("order") List<Ordering> order,
            @QueryParam("worker") String workerName,
            List<String> targets);

    /**
     * Find all active Deployment Tasks, optionally filtered by parameters.
     *
     * @headers Content-Type application/json
     * @headers Cookie &lt;Cookie Value&gt;
     * @headers X-XSRF-TOKEN &lt;X-XSRF-TOKEN&gt;
     * @param begin filter by time interval beginning with date
     * @param end filter by time interval ending with date
     * @param states (Optional) filter task by task state
     * @param users (Optional) filter tasks belonging to users
     * @param taskTypes (Optional) filter by task type - DEFAULT, INITIAL, ROLLBACK, UNDEPLOY, UPGRADE
     * @param taskId (Optional) filter task with exact taskId
     * @param fetchMode (Optional) toggle to fetch FULL task with blocks or just task SUMMARY
     * @param taskSet filter by taskSet - MY or ALL
     * @param onlySuccessful Deprecated use states instead
     * @param paging (Optional) Which page and how many results per page to retrieve
     * @param order (Optional) Which ordering to use when listing results
     * @param workerName (Optional) filter only specified workers
     * @param configurationItemIds filter by list of CIs - environment and application correlated to the Deployment task
     * @return list of {@link TaskWithBlock}
     */
    @POST
    @Path("deployment")
    Stream<TaskWithBlock> getDeploymentTasks(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @QueryParam("states") List<String> states,
            @QueryParam("users") List<String> users,
            @QueryParam("types") List<String> taskTypes,
            @QueryParam("taskId") String taskId,
            @QueryParam("fetchMode") FetchMode fetchMode,
            @QueryParam("taskSet") TaskSet taskSet,
            @QueryParam("onlySuccessful") boolean onlySuccessful,
            @BeanParam Paging paging,
            @QueryParam("order") List<Ordering> order,
            @QueryParam("worker") String workerName,
            List<ConfigurationItemId> configurationItemIds);
}
