/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.jaxb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="maps")
public class CollectionOfMapsMapElement {
    private Collection<MapEntry[]> mapEntriesCollection;

    public CollectionOfMapsMapElement() {
    }

    public CollectionOfMapsMapElement(Collection<Map<String, String>> maps) {
        this.mapEntriesCollection = Lists.newArrayList();
        for (Map<String, String> each : maps) {
            ArrayList entries = Lists.newArrayList();
            for (Map.Entry<String, String> eachEntry : each.entrySet()) {
                entries.add(new MapEntry(eachEntry));
            }
            this.mapEntriesCollection.add(entries.toArray(new MapEntry[entries.size()]));
        }
    }

    @XmlElement(name="map")
    public Collection<MapEntry[]> getMapEntriesCollection() {
        return this.mapEntriesCollection;
    }

    public void setMapEntriesCollection(Collection<MapEntry[]> maps) {
        this.mapEntriesCollection = maps;
    }

    @XmlTransient
    public Collection<Map<String, String>> getMaps() {
        ArrayList maps = Lists.newArrayList();
        for (MapEntry[] each : this.mapEntriesCollection) {
            HashMap m = Maps.newHashMap();
            for (MapEntry eachEntry : each) {
                m.put(eachEntry.getKey(), eachEntry.getValue());
            }
            maps.add(m);
        }
        return maps;
    }

    @XmlRootElement
    public static class MapEntry {
        private String key;
        private String value;

        public MapEntry() {
        }

        public MapEntry(Map.Entry<String, String> mapEntry) {
            this.key = mapEntry.getKey();
            this.value = mapEntry.getValue();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

