package com.xebialabs.deployit.core.api.resteasy;

import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServerErrorClientResponseInterceptor implements ClientErrorInterceptor {
	private static final String NO_HEADER_PRESENT = "Found no header from Deployit! BAD situation... Please contact deployit-support@xebialabs.com";

	@Override
	public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
		logger.info("Handling Error Response, status code: {}", clientResponse.getStatus());
        tryDeployitException(clientResponse);
        tryUnhandledException(clientResponse);

	}

	private void tryUnhandledException(final ClientResponse<?> clientResponse) {
		if ("true".equals(clientResponse.getHeaders().getFirst("Unhandled-Exception"))) {
			logger.debug("Found unhandled header");
			final String exceptionType = clientResponse.getHeaders().getFirst("Exception-Type");

			String unhandledMessage = clientResponse.getEntity(String.class);
			throw new UnhandledException(exceptionType, unhandledMessage);
		}
	}

	private void tryDeployitException(final ClientResponse<?> clientResponse) {
		if ("true".equals(clientResponse.getHeaders().getFirst("Deployit-Exception"))) {
			logger.debug("Found Deployit header");
			final String messages = clientResponse.getEntity(String.class);
			throw new DeployitClientException(messages);
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);
}
