package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import org.jboss.resteasy.annotations.ClientResponseType;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/descriptor")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface DescriptorProxy {

	@GET
	@ClientResponseType(entityType = ConfigurationItemDescriptorList.class)
	Response list();

    @GET
    @Path("{type}")
    @ClientResponseType(entityType = ConfigurationItemDescriptorDto.class)
    Response find(@PathParam("type") String type);
    
}
