package com.xebialabs.deployit.core.api.dto;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementWrapper;
import com.xebialabs.deployit.core.api.dto.StepInfo;

@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement(name="archived-task")
public class FullTaskInfo extends TaskInfo {

	private List<StepInfo> stepInfoList = new ArrayList<StepInfo>();

	public FullTaskInfo(){
	}

	@XmlElement(name="step")
	@XmlElementWrapper(name="steps")
	public List<StepInfo> getSteps() {
		return stepInfoList;
	}

	public void setSteps(final List<StepInfo> stepInfos) {
		this.stepInfoList = stepInfos;
	}

	public boolean addStep(final StepInfo stepInfo) {
		return (stepInfo != null) ? this.stepInfoList.add(stepInfo) : false;
	}

	public boolean addSteps(final Collection<? extends StepInfo> stepInfos) {
		return (stepInfos != null) ? this.stepInfoList.addAll(stepInfos) : false;
	}

	public boolean hasSteps() {
		return (this.stepInfoList != null) && !this.stepInfoList.isEmpty();
	}
}
